set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9604470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0323',
      '24241114',
      '31101233',
      '01420414',
      '41413422',
      NULL,
      '41344434',
      '31442240',
      NULL,
      NULL,
      '44310013',
      '40334340',
      NULL,
      NULL,
      NULL,
      '11040430',
      '32334030',
      '43103203',
      NULL,
      '04313212',
      '14424134',
      '40340132',
      '32220231',
      '01222102',
      NULL,
      '20322140',
      '00114111',
      '43114104',
      '02300420',
      '12001440',
      '42003114',
      NULL,
      '12421431',
      '13121432',
      NULL,
      '41211304',
      '41221433',
      NULL,
      '20422040',
      '40030312',
      '24220130',
      '23444414',
      NULL,
      '12331434',
      '30341112',
      '340',
      NULL,
      NULL,
      NULL,
      '2422422',
      1,
      0.376710,
      2,
      NULL,
      NULL,
      2,
      '10- 7-1997',
      NULL,
      7.341002,
      NULL,
      3,
      12.948166,
      22,
      10.580893,
      19,
      12.450510,
      8,
      NULL,
      NULL,
      17.787472,
      37.558202,
      3,
      0.785732,
      12,
      6,
      NULL,
      49,
      3.750810,
      NULL,
      5,
      40,
      8.068097,
      NULL,
      9.655204,
      112.100539,
      68,
      135,
      NULL,
      96,
      ' 1- 2-1982',
      34.060582,
      11,
      24,
      4.527341,
      NULL,
      94,
      ' 2-25-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      76.382408,
      26,
      42,
      10,
      1,
      1.341781,
      ' 8-26-2001',
      0.847499,
      2,
      40.207081,
      2,
      NULL,
      NULL,
      0.584347,
      3,
      21,
      NULL,
      NULL,
      NULL,
      '11- 5-1977',
      5.558816,
      103.906948,
      102,
      41.834550,
      45.621509,
      78.875221,
      88.055944,
      69.907511,
      58.608085,
      NULL,
      NULL,
      12.907799,
      '10-24-1983',
      2,
      NULL,
      3.612914,
      37,
      12,
      43.038133,
      NULL,
      ' 0-25-1984',
      3.057882,
      NULL,
      ' 4-25-1981',
      10.958004,
      10,
      NULL,
      9,
      8,
      4.633084,
      NULL,
      5,
      1,
      54.146099,
      2.455582,
      NULL,
      3.971022,
      7.086353,
      6.623525,
      2,
      0.806021,
      1,
      ' 7-15-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      14,
      '10- 3-1991',
      NULL,
      NULL,
      NULL,
      53,
      ' 9-19-1982',
      21.567881,
      '11- 9-2001',
      NULL,
      1.100042,
      ' 9-24-1976',
      NULL,
      NULL,
      NULL,
      0.420836,
      8.533109,
      ' 4- 9-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      ' 5- 7-1982',
      42.992598,
      18,
      15,
      ' 9-17-1991',
      NULL,
      51,
      '11- 7-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


