set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6310997';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0224',
      '14000424',
      '21223244',
      '23341314',
      '10030300',
      '03104042',
      '34323122',
      NULL,
      NULL,
      '34213443',
      '01303244',
      '14203214',
      NULL,
      NULL,
      NULL,
      '14212440',
      '02012420',
      '44212124',
      NULL,
      '42204240',
      '01141141',
      '22220022',
      '11410011',
      '31420200',
      NULL,
      '34400222',
      NULL,
      '21110343',
      '03313233',
      '21001434',
      '22003013',
      '13122343',
      '43120412',
      '13430121',
      NULL,
      '22440402',
      '12023120',
      '03310200',
      '32200142',
      '20114424',
      '12001403',
      NULL,
      '30124442',
      '41100412',
      NULL,
      NULL,
      '01',
      NULL,
      NULL,
      '1043432',
      NULL,
      1,
      2,
      NULL,
      '140443',
      NULL,
      NULL,
      NULL,
      8.193720,
      NULL,
      19,
      19,
      40,
      24.800066,
      76,
      17,
      17.163600,
      9.876704,
      41,
      NULL,
      28,
      21,
      35,
      21.495639,
      20.389036,
      32.096107,
      NULL,
      22.766108,
      NULL,
      NULL,
      53,
      NULL,
      0.751015,
      NULL,
      206,
      80.708291,
      231,
      NULL,
      NULL,
      ' 9-14-1990',
      48.688232,
      17,
      NULL,
      9,
      19,
      126,
      ' 3- 4-2000',
      0.254063,
      NULL,
      1.177458,
      0,
      NULL,
      3,
      0,
      1,
      0.545798,
      1,
      4,
      0,
      NULL,
      0,
      0,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-1992',
      NULL,
      12.715739,
      7.252525,
      1,
      NULL,
      6.600404,
      ' 2-17-1992',
      1,
      1.993222,
      NULL,
      0.444095,
      NULL,
      84.453062,
      0,
      0,
      30.209584,
      1.020260,
      NULL,
      7,
      NULL,
      NULL,
      110.412029,
      81.188719,
      34,
      NULL,
      17.817245,
      10.182083,
      NULL,
      73.176802,
      21.908739,
      NULL,
      60.177167,
      ' 3- 7-1991',
      5,
      2,
      1.725235,
      61,
      61,
      145.553409,
      8.501168,
      ' 7-21-2000',
      NULL,
      21.245021,
      NULL,
      1,
      13.186869,
      5,
      NULL,
      19,
      9,
      1.661669,
      16.152514,
      1.483810,
      85,
      NULL,
      0,
      19.000134,
      10.438978,
      1,
      2.206620,
      NULL,
      3,
      NULL,
      2.364484,
      4.306300,
      3.066215,
      '11-16-1998',
      168.847156,
      NULL,
      '10- 6-1979',
      NULL,
      2,
      NULL,
      11,
      NULL,
      13,
      NULL,
      7.480858,
      4.453988,
      ' 2- 3-2001',
      91.142027,
      62,
      ' 6-15-1975',
      6.480874,
      1.778663,
      ' 2-25-1977',
      0.336641,
      NULL,
      ' 9-13-1993',
      0,
      NULL,
      10.243763,
      ' 4-17-1985',
      42.003814,
      44.620496,
      6,
      ' 7-11-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.384816);
commit;
end;
/


