set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2013',
      '41042223',
      '14321031',
      '21011030',
      '33123344',
      '33401112',
      '40042440',
      '12213400',
      '34403433',
      '01322344',
      '42444321',
      '13333132',
      '42311331',
      '01202104',
      '44302342',
      '32002410',
      '22014112',
      NULL,
      NULL,
      '01011411',
      NULL,
      '23201333',
      '32141443',
      '03314213',
      '41340332',
      '24004203',
      '04300402',
      '04330341',
      '42430101',
      NULL,
      '23013230',
      '04211240',
      '04034321',
      '42230400',
      '01134221',
      NULL,
      '43200134',
      '41221224',
      '34044121',
      '32204400',
      '33333101',
      '11301111',
      '33123400',
      NULL,
      NULL,
      '012',
      NULL,
      20,
      8,
      NULL,
      2.062795,
      1.902914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1988',
      80,
      NULL,
      10.892261,
      8,
      14,
      10,
      58.803843,
      9.244419,
      8.082090,
      19,
      31,
      12,
      38,
      0.554133,
      17,
      13.861521,
      6.833218,
      4.799303,
      43,
      3,
      44,
      20,
      NULL,
      NULL,
      0.934288,
      64.615569,
      54,
      45,
      NULL,
      149.470444,
      75,
      ' 8-19-1981',
      NULL,
      33.430290,
      NULL,
      25,
      NULL,
      186,
      ' 8- 2-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      NULL,
      30.010698,
      16.049410,
      0.594292,
      '11- 1-1987',
      0,
      2,
      NULL,
      NULL,
      1,
      24.977110,
      NULL,
      NULL,
      19.332503,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      40.185409,
      12,
      NULL,
      5.175460,
      55.228583,
      58.491399,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 9- 2-2001',
      22.339403,
      NULL,
      3.652489,
      12.838481,
      27,
      94.237903,
      10,
      ' 0-10-1980',
      2.097403,
      2,
      NULL,
      3,
      NULL,
      5.652603,
      1.763436,
      11,
      3.706002,
      1,
      5,
      0.946927,
      16.303407,
      1.239587,
      1,
      0,
      NULL,
      7.696699,
      NULL,
      NULL,
      0.814465,
      ' 8- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      4.642694,
      ' 0- 8-1980',
      NULL,
      NULL,
      NULL,
      3.584967,
      ' 6-27-1981',
      9.254911,
      ' 9- 1-1983',
      15,
      5,
      ' 4-12-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.558763,
      ' 8- 2-1979',
      65,
      36,
      23,
      '11-21-1981',
      4,
      135.378837,
      ' 9- 8-1986',
      2.720767,
      55.779413,
      21.514924,
      56,
      ' 0- 5-2000',
      54.692401,
      1.017956,
      21,
      ' 5-22-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


