set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1403',
      '13211422',
      NULL,
      '23013420',
      '44311001',
      '12140343',
      '02012233',
      '23431211',
      '24231101',
      '01203423',
      '34423323',
      NULL,
      NULL,
      '12221411',
      '33000141',
      '33222243',
      NULL,
      '41224142',
      '31200032',
      NULL,
      NULL,
      '11142313',
      NULL,
      '24112004',
      '44233230',
      NULL,
      '01134042',
      '41341144',
      '40434420',
      '44112414',
      NULL,
      '40443312',
      '03142333',
      '32032241',
      '00102041',
      '34303330',
      '34332333',
      '13000324',
      NULL,
      '13401023',
      '30023334',
      '40144122',
      '21334332',
      '10010302',
      '11002224',
      '311',
      '01',
      NULL,
      24.687251,
      NULL,
      0,
      23,
      NULL,
      NULL,
      '334324',
      2.523724,
      ' 2-22-1986',
      ' 7-25-1976',
      61.190244,
      83.565408,
      45,
      17.561015,
      16,
      9.648964,
      106,
      0,
      32,
      NULL,
      7.199856,
      8,
      0,
      1,
      14.425730,
      16.601150,
      15.586841,
      24.380777,
      26,
      27.552021,
      22,
      24.877142,
      102,
      18,
      0,
      90.004642,
      206,
      95.637404,
      NULL,
      NULL,
      136.399540,
      ' 1-18-1985',
      8,
      NULL,
      32,
      37,
      46,
      NULL,
      ' 7-14-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66,
      35.771362,
      14,
      27.413707,
      1.557229,
      4.286673,
      NULL,
      1,
      0,
      NULL,
      0.313902,
      NULL,
      112.003572,
      0.061584,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-23-1980',
      NULL,
      21,
      56.737174,
      108.428855,
      37.447472,
      27.540317,
      42,
      79.528973,
      87,
      29,
      36.577523,
      NULL,
      ' 1- 8-1978',
      1.313926,
      29,
      NULL,
      99,
      77.999081,
      35,
      NULL,
      ' 6-13-1989',
      NULL,
      NULL,
      NULL,
      1.950229,
      0.964766,
      NULL,
      18,
      16.785765,
      NULL,
      1.269759,
      NULL,
      1,
      54,
      7,
      2,
      14.781392,
      15.817075,
      4.021446,
      2.920442,
      2.072308,
      1,
      ' 5-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      77.078942,
      1.789424,
      ' 2- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1998',
      22.342734,
      ' 3-14-1997',
      15,
      4.567194,
      ' 2-26-1990',
      NULL,
      55,
      ' 3-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      6.657893,
      '10-19-1974',
      13.691007,
      5,
      45.148782,
      '11- 1-1998',
      0,
      83.694077,
      ' 6-16-1992',
      7,
      3,
      0.152998,
      8,
      ' 0-23-1992',
      37,
      NULL,
      45.718066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


