set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9221530';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4120',
      NULL,
      '23202410',
      '12330344',
      '34204234',
      NULL,
      '23020333',
      '24323412',
      '40104024',
      '10442100',
      '00333114',
      '13023043',
      NULL,
      NULL,
      '34330002',
      NULL,
      '21240311',
      '31024333',
      '04000221',
      '11102202',
      '00323143',
      '22314430',
      '40221313',
      NULL,
      NULL,
      NULL,
      '34113042',
      '13142433',
      '41302213',
      '32130210',
      '00200430',
      '21222321',
      '30044021',
      NULL,
      '21223300',
      NULL,
      '03103442',
      '34230420',
      '33311421',
      '11341014',
      '24234433',
      NULL,
      '24232030',
      '02444004',
      '02031334',
      NULL,
      NULL,
      NULL,
      NULL,
      '2214241',
      2,
      1,
      NULL,
      NULL,
      '023022',
      3,
      ' 8- 8-1997',
      '10- 4-1975',
      3.669467,
      NULL,
      NULL,
      5.247123,
      10,
      10.777593,
      26,
      NULL,
      10,
      12.225285,
      21.803928,
      12.408230,
      13.492728,
      0.748268,
      NULL,
      5.289672,
      9.180419,
      NULL,
      19,
      13,
      32.350275,
      6.587012,
      128,
      NULL,
      0,
      29.521744,
      108.553980,
      79,
      45,
      100,
      42.672316,
      ' 5- 7-1981',
      2,
      NULL,
      15,
      8,
      84.346037,
      161,
      NULL,
      NULL,
      0,
      3.416617,
      3.644367,
      0.385791,
      1.585468,
      3,
      2,
      0,
      0.420436,
      1.952544,
      1,
      0,
      4,
      0.153995,
      1,
      0.138237,
      1.461168,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-1977',
      92.780339,
      4.625790,
      9,
      NULL,
      0.076871,
      0,
      NULL,
      NULL,
      5,
      120,
      0,
      3.461960,
      90.035263,
      4,
      3.153770,
      34,
      1.650364,
      3,
      80,
      ' 7-17-1975',
      57,
      59.883520,
      NULL,
      34,
      53,
      11.306610,
      85.009476,
      16,
      40.272054,
      7.632923,
      54,
      12,
      ' 9- 7-1988',
      9.107199,
      NULL,
      21.281434,
      NULL,
      2.358961,
      NULL,
      0,
      ' 2-13-1992',
      22.152917,
      NULL,
      NULL,
      5,
      5,
      1.560000,
      6,
      28.391629,
      13,
      1,
      NULL,
      0,
      59.771855,
      1,
      6,
      NULL,
      NULL,
      NULL,
      0.343426,
      NULL,
      NULL,
      '10- 2-1978',
      NULL,
      0.830835,
      NULL,
      ' 7-19-1991',
      101,
      1.585055,
      ' 1-13-1999',
      39.903589,
      18.173624,
      '10-11-2000',
      NULL,
      '11- 8-1996',
      48,
      ' 9- 2-1985',
      NULL,
      18.392384,
      ' 7- 9-1998',
      65.050501,
      91,
      ' 1-22-1982',
      3,
      3.388621,
      ' 5- 7-1992',
      6.469143,
      8.042988,
      ' 6- 5-1990',
      0,
      3,
      20,
      ' 3- 6-1999',
      NULL,
      5,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


