set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7913233';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0004',
      '23231201',
      NULL,
      '44423224',
      '40024244',
      '24312314',
      '40242441',
      NULL,
      '30334431',
      '31040341',
      '33211324',
      '42034013',
      '34302433',
      '43032401',
      '11343243',
      '23001101',
      '32432133',
      '10200214',
      '32340133',
      NULL,
      '20111224',
      '10110114',
      '11224320',
      NULL,
      NULL,
      '00302223',
      '33432413',
      '24203113',
      '14011121',
      '03243330',
      '02441202',
      NULL,
      '43233230',
      '44343323',
      '22302010',
      '24333202',
      '13304022',
      '32142202',
      '20430212',
      '20433422',
      '24332433',
      '01110334',
      '01211441',
      '14043343',
      '33411331',
      '110',
      '03',
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5.693030,
      ' 9-10-1994',
      ' 1-19-1992',
      94,
      NULL,
      NULL,
      10,
      NULL,
      3.417472,
      89.578863,
      15.820149,
      4.495160,
      9.345569,
      1.210696,
      4,
      6,
      8,
      23,
      20.493721,
      NULL,
      7.571067,
      NULL,
      1.760821,
      46,
      13.282942,
      31.062165,
      13,
      NULL,
      32.632241,
      179.563621,
      49,
      136.406545,
      43,
      NULL,
      NULL,
      9,
      36.695041,
      NULL,
      NULL,
      92.617044,
      34.336829,
      NULL,
      0,
      3.778721,
      0.722633,
      2,
      3,
      NULL,
      1.694542,
      3.505882,
      1,
      1,
      0,
      0,
      1,
      0,
      1.053388,
      1,
      1.974538,
      1.587875,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      4.828305,
      4,
      '10-11-1992',
      NULL,
      1.230905,
      100.694258,
      0.218782,
      NULL,
      115,
      0,
      0,
      70.642297,
      NULL,
      NULL,
      NULL,
      ' 5-24-1988',
      NULL,
      23.903509,
      58,
      NULL,
      43.464926,
      NULL,
      87.127700,
      56,
      NULL,
      86.163809,
      18.922925,
      13,
      '10-29-1984',
      6,
      7,
      NULL,
      20,
      17,
      2,
      NULL,
      ' 9-15-1975',
      0,
      1,
      ' 6-22-1981',
      7.957280,
      11,
      9.246922,
      9,
      2.396388,
      0.585439,
      0,
      17.343679,
      NULL,
      6.550845,
      0,
      1.117886,
      11.149842,
      23.082679,
      1.183033,
      NULL,
      0,
      2,
      ' 9-19-1975',
      2.875119,
      NULL,
      1.802670,
      NULL,
      105,
      NULL,
      ' 5-29-1993',
      NULL,
      NULL,
      NULL,
      2,
      ' 7- 7-1987',
      11.058913,
      '11- 2-1983',
      10,
      21,
      ' 6-19-1982',
      126.741316,
      11.341234,
      NULL,
      NULL,
      5.821149,
      ' 5- 0-1994',
      NULL,
      5.250103,
      ' 6- 3-2001',
      1,
      2,
      7,
      ' 0-24-1999',
      53,
      4.206860,
      NULL,
      ' 7-17-1981',
      2.084074,
      362.418025,
      ' 1-14-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.141509);
commit;
end;
/


