set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0442',
      '21431132',
      NULL,
      '34041021',
      NULL,
      '34341233',
      '03342334',
      '24411322',
      '03443442',
      '22134220',
      '20422132',
      '10024004',
      '23032332',
      '33110410',
      '32244102',
      '32241340',
      '31213022',
      '41412230',
      '43334413',
      '01431123',
      NULL,
      '22140141',
      '21101024',
      NULL,
      NULL,
      '00024301',
      '12204424',
      '10320433',
      '34033440',
      '40334230',
      '34020321',
      '42110034',
      '22142320',
      NULL,
      NULL,
      '11434224',
      '22041110',
      NULL,
      '04122132',
      '01021203',
      NULL,
      NULL,
      NULL,
      '04340332',
      NULL,
      '432',
      '33',
      NULL,
      NULL,
      '2201222',
      2.539855,
      0.806307,
      3,
      NULL,
      '241134',
      3.004623,
      ' 2- 5-1987',
      '10-19-1974',
      2,
      NULL,
      1.913216,
      14.619971,
      NULL,
      NULL,
      71.774530,
      NULL,
      9.405210,
      NULL,
      NULL,
      NULL,
      39.155605,
      0,
      29,
      18,
      29.021516,
      12,
      NULL,
      8,
      NULL,
      0.787856,
      6.051125,
      NULL,
      1,
      73,
      160,
      NULL,
      166.163494,
      97,
      157,
      ' 2- 1-1993',
      61.496532,
      69.185204,
      38,
      32.468440,
      70,
      128.541496,
      ' 7-29-1981',
      0,
      6.683483,
      NULL,
      1.592842,
      0,
      7.478776,
      0,
      2,
      0,
      0.769777,
      1,
      0.947851,
      0.810247,
      0.129381,
      NULL,
      NULL,
      1.907834,
      0,
      0,
      0.792000,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-17-1999',
      86.768084,
      4,
      NULL,
      11.472203,
      0.361910,
      4.268809,
      NULL,
      1,
      0,
      29,
      1.916924,
      3,
      60,
      0.611393,
      NULL,
      38.714444,
      NULL,
      NULL,
      NULL,
      ' 8-17-1996',
      40,
      14.618139,
      NULL,
      65,
      104,
      57.586857,
      9.059901,
      77,
      NULL,
      34.591749,
      41.297124,
      38,
      ' 0-29-1987',
      29.188732,
      16.339717,
      22,
      86.157058,
      35.230816,
      55,
      5.080385,
      NULL,
      1,
      5,
      '10- 1-1974',
      1,
      5,
      14.807766,
      11,
      20,
      0.658074,
      1.454891,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.820045,
      1,
      1.021240,
      2.338327,
      0,
      '10-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      7,
      ' 4- 1-1995',
      NULL,
      NULL,
      NULL,
      33,
      ' 5-13-1999',
      NULL,
      ' 9-27-1997',
      12.152600,
      1,
      ' 3-20-1995',
      NULL,
      NULL,
      NULL,
      1,
      9.805227,
      '10- 4-2002',
      NULL,
      NULL,
      NULL,
      3,
      2,
      10.547582,
      '11- 5-1979',
      6,
      47.865163,
      30.728658,
      ' 9- 6-1982',
      6,
      234,
      ' 4-20-1994',
      NULL,
      5,
      13.265678,
      27.359139,
      ' 8- 7-1995',
      52,
      1.182314,
      NULL,
      ' 5-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


