set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3321',
      '32222040',
      '00244130',
      '21204013',
      '31430113',
      '14131040',
      '42430011',
      '33101004',
      NULL,
      '23112344',
      '20331332',
      '42144010',
      '10010003',
      '01141202',
      '30022302',
      '11104102',
      NULL,
      '11222432',
      '43143423',
      '23202124',
      '40142023',
      '00231242',
      '04413211',
      '20123332',
      '33430412',
      '13231202',
      '20002002',
      NULL,
      '34132111',
      '04040320',
      '31004432',
      '00302400',
      '34003100',
      '33334140',
      NULL,
      NULL,
      NULL,
      '41143432',
      '31433004',
      '33302330',
      '01431004',
      '21402110',
      NULL,
      NULL,
      '22013232',
      NULL,
      '00',
      34.388027,
      0,
      '2020112',
      0.700728,
      NULL,
      3,
      NULL,
      '024022',
      1.350654,
      ' 5-18-1980',
      NULL,
      30,
      121.541545,
      39,
      18,
      26.520465,
      2.448630,
      NULL,
      19.217492,
      16,
      7,
      NULL,
      16.629911,
      4,
      NULL,
      9,
      17.831146,
      1.813600,
      5.176801,
      NULL,
      17.029399,
      19.346226,
      9,
      NULL,
      13.073546,
      0,
      6,
      74.371622,
      NULL,
      NULL,
      25.499755,
      NULL,
      ' 2- 2-1975',
      60,
      11,
      25.492926,
      20.375266,
      187,
      163.210896,
      ' 1-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99.684013,
      0,
      11.574366,
      11.756563,
      NULL,
      NULL,
      ' 2-22-1986',
      1.920735,
      1,
      38.987013,
      NULL,
      NULL,
      129,
      0.698327,
      0,
      18,
      NULL,
      NULL,
      NULL,
      ' 1-13-1983',
      92,
      54.530996,
      92,
      68.620517,
      55.888041,
      9.910259,
      12,
      76.502822,
      57,
      40,
      NULL,
      NULL,
      ' 5- 8-1987',
      NULL,
      NULL,
      8.140857,
      NULL,
      NULL,
      131.063546,
      5.694020,
      ' 2-11-1998',
      8.760472,
      6,
      NULL,
      8,
      2.756778,
      21,
      7,
      18,
      2.157276,
      0,
      15.298161,
      0,
      31,
      1,
      13.063702,
      18,
      25.131915,
      0,
      1.076253,
      4.584687,
      1,
      ' 1-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.431931,
      ' 9-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-16-1975',
      14,
      ' 7- 6-2001',
      12.438012,
      19,
      NULL,
      11.744595,
      94,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.050748,
      ' 3-17-1975',
      1.655390,
      NULL,
      ' 9- 4-1980',
      1.019633,
      NULL,
      17,
      31.490436,
      ' 7-29-1987',
      NULL,
      1.234890,
      128.284286,
      ' 2-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


