set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '2',
      '3',
      '1',
      '2',
      '2',
      '4',
      '2',
      '4',
      '3',
      '4',
      '4',
      '0',
      '0',
      '3',
      '4',
      '4',
      '1',
      NULL,
      '4',
      '2',
      NULL,
      '4',
      NULL,
      '1',
      '',
      '0',
      '1',
      NULL,
      '0',
      NULL,
      '',
      NULL,
      NULL,
      '2',
      '4',
      '2',
      '4',
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '4',
      '212',
      '03321224',
      NULL,
      9.247728,
      '1333034',
      1.300037,
      57.181233,
      2,
      NULL,
      '313324',
      4,
      NULL,
      ' 9-25-1987',
      20.925787,
      154,
      NULL,
      8,
      19.263033,
      16,
      27.340119,
      12,
      17,
      5.223546,
      0.803848,
      2,
      30,
      5.380033,
      16,
      3.589092,
      29,
      12,
      31.064066,
      4,
      43,
      12,
      19.276578,
      6.680393,
      0.246372,
      64.759616,
      166.582867,
      1.079760,
      58,
      NULL,
      10,
      ' 9-27-1983',
      NULL,
      6.958490,
      NULL,
      33,
      156.735527,
      175.133498,
      ' 3- 4-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      3,
      4,
      23,
      1,
      NULL,
      NULL,
      0,
      180,
      0,
      1.496773,
      88.277333,
      NULL,
      0.564602,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-1989',
      38,
      NULL,
      14,
      55,
      NULL,
      28.095666,
      94.367910,
      98.687061,
      25,
      65.625276,
      NULL,
      3.603808,
      ' 2-11-1985',
      7.869612,
      1.951317,
      NULL,
      6.906231,
      51,
      17,
      7.279373,
      NULL,
      NULL,
      NULL,
      ' 5-18-1977',
      8,
      11,
      17,
      21.395827,
      22,
      9.062055,
      1.955820,
      4,
      0.980101,
      NULL,
      1,
      0,
      12,
      1,
      0,
      5,
      NULL,
      1,
      ' 1-11-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      37.586912,
      5,
      ' 1- 3-1986',
      NULL,
      NULL,
      NULL,
      19.816939,
      ' 5- 4-2001',
      1.870241,
      ' 7-18-1980',
      9.729571,
      1,
      ' 1-25-1998',
      43,
      17.743749,
      '10-27-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.780653,
      NULL,
      72.542267,
      30.122055,
      26.075920,
      ' 5- 8-1985',
      0,
      NULL,
      '10-11-2001',
      5.143867,
      NULL,
      19,
      16,
      NULL,
      10.039208,
      0.264540,
      93.416911,
      '10- 8-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


