set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9435005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '2',
      '0',
      '0',
      '2',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '1',
      '1',
      '2',
      '3',
      NULL,
      '3',
      NULL,
      '0',
      '2',
      '2',
      '0',
      '4',
      '',
      NULL,
      '',
      '2',
      '1',
      '1',
      '4',
      '3',
      '',
      '',
      '2',
      '2',
      '2',
      '0',
      '2',
      NULL,
      '4',
      '0',
      '0',
      '2',
      '0',
      '024',
      '43203000',
      12.463890,
      NULL,
      NULL,
      2.448847,
      6,
      2,
      NULL,
      '442402',
      4.494720,
      '10-23-1994',
      ' 4- 5-1985',
      NULL,
      NULL,
      13,
      5,
      29.390786,
      17.841656,
      31.629380,
      23.539157,
      NULL,
      23.831320,
      40.983534,
      16,
      38,
      18.502064,
      7.605605,
      25,
      NULL,
      1.654433,
      NULL,
      NULL,
      22.577495,
      7.956393,
      95.252399,
      7.681212,
      1,
      109.203907,
      206.487766,
      31,
      NULL,
      97.258200,
      NULL,
      ' 7-18-1996',
      5.696687,
      33,
      7.965910,
      15,
      122.056162,
      NULL,
      ' 3-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.923453,
      15,
      NULL,
      0,
      10,
      0.175984,
      ' 7-28-1988',
      0.372590,
      0,
      NULL,
      1.350916,
      0.304730,
      149.912275,
      0.164701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1983',
      94,
      71.855325,
      107.313092,
      97.628134,
      97,
      65.138733,
      43,
      NULL,
      17.258735,
      19,
      17.391033,
      33.903620,
      NULL,
      12.326788,
      18,
      NULL,
      79,
      79,
      112.791297,
      2.941876,
      '11- 1-1987',
      22.357538,
      1,
      ' 7-11-2000',
      NULL,
      NULL,
      8.272674,
      4.088688,
      NULL,
      NULL,
      1,
      13,
      0,
      NULL,
      3.246890,
      0,
      6,
      9.338599,
      0,
      0.728769,
      1.618133,
      NULL,
      ' 2- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-16-1999',
      NULL,
      NULL,
      NULL,
      31,
      ' 5- 7-1980',
      31.743731,
      ' 7-14-1980',
      13,
      4,
      ' 9-13-1993',
      17,
      92.021643,
      '10- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      4,
      ' 0-28-1990',
      64.282696,
      21.029264,
      23,
      ' 2-26-1996',
      0,
      121.785276,
      NULL,
      12,
      5,
      16.621091,
      NULL,
      ' 5- 1-1983',
      37.621162,
      NULL,
      NULL,
      ' 2-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


