set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8603761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41244304',
      '34403302',
      '21144230',
      NULL,
      NULL,
      '42420030',
      '22323141',
      NULL,
      NULL,
      '34233202',
      '20040120',
      '32303003',
      '14400142',
      '20002312',
      '10410441',
      NULL,
      '34431134',
      '20010234',
      '33100113',
      NULL,
      '03422211',
      '03240342',
      '42103431',
      '11423421',
      '21024310',
      '20033223',
      '21124430',
      '40330443',
      '22344443',
      '30334022',
      NULL,
      '40342101',
      '13232032',
      '20240100',
      '03232014',
      '03102244',
      NULL,
      '23312020',
      '03011304',
      NULL,
      '23411334',
      '03224432',
      '42433310',
      '33332303',
      '',
      '',
      NULL,
      NULL,
      '0042444',
      2,
      1,
      1,
      NULL,
      '044202',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      1,
      NULL,
      3,
      24.107468,
      16.170208,
      3.216721,
      30.422000,
      NULL,
      37,
      10,
      0,
      15.038819,
      6.944829,
      0.170492,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      7.593983,
      NULL,
      132,
      243,
      43.010030,
      81.244868,
      218,
      106,
      NULL,
      41.224949,
      63,
      9,
      NULL,
      NULL,
      15,
      NULL,
      4,
      1.725233,
      0.632747,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896299,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      16,
      NULL,
      NULL,
      70,
      31,
      102.990867,
      90,
      48.851507,
      84.581931,
      77,
      55.304632,
      NULL,
      10.265519,
      27,
      15.497523,
      18.495082,
      48,
      155.250867,
      8.255070,
      NULL,
      12.498973,
      1,
      NULL,
      2,
      8.516223,
      18.491738,
      30,
      NULL,
      0,
      NULL,
      31,
      NULL,
      99.537917,
      1.646855,
      0,
      2.921647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      26,
      NULL,
      1.840046,
      66,
      NULL,
      12,
      43.083502,
      8,
      NULL,
      NULL,
      NULL,
      0.968887,
      31.472405,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      1,
      NULL,
      84,
      85.165414,
      22,
      21,
      9.467965,
      21,
      4,
      8.592735,
      NULL,
      NULL,
      1.148976,
      42,
      0,
      1,
      61.765183,
      0.904655,
      NULL,
      96,
      0,
      0,
      148.057276,
      70.903806,
      18.825977,
      NULL,
      0.837091,
      6,
      1.154114,
      1.474072,
      1.169032,
      0.113701,
      1.087014,
      NULL,
      85,
      14,
      NULL,
      24.514182,
      68.653913,
      32.564019,
      1.775542,
      2,
      6,
      0,
      NULL,
      NULL,
      19,
      1,
      65.186181,
      0,
      5,
      0.289377,
      0,
      35,
      13,
      9.385160,
      20,
      75,
      29,
      24,
      79.304204,
      2.644000,
      5.226554,
      1.046623,
      9,
      1.360642,
      NULL,
      1.260007,
      0,
      78.527310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


