set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7434612';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42314311',
      NULL,
      '22113041',
      '11023142',
      '20232023',
      '40444323',
      '24323323',
      '00404210',
      '24122321',
      NULL,
      '10212303',
      '42411300',
      '43111321',
      '20113411',
      '01434444',
      '02414010',
      '33124010',
      NULL,
      '00433120',
      '24201214',
      '13211224',
      '00112012',
      NULL,
      '23103133',
      NULL,
      NULL,
      '00104120',
      '20020201',
      '01400412',
      '42403413',
      '22412324',
      '04414003',
      '34004400',
      '44014031',
      NULL,
      '20032441',
      '02431242',
      '12320012',
      '20203131',
      '34021344',
      '23120400',
      '13041143',
      '03331112',
      '04020014',
      '044',
      NULL,
      NULL,
      NULL,
      '3224123',
      2.024741,
      1,
      2,
      NULL,
      '304023',
      4,
      ' 9- 1-2003',
      '11-29-1998',
      60.762431,
      NULL,
      25.002452,
      15.585319,
      13,
      NULL,
      50.577292,
      9,
      5.629172,
      32,
      5,
      0,
      21.634093,
      1,
      30,
      11.402009,
      NULL,
      1.948539,
      61.487738,
      20.380821,
      NULL,
      8.592841,
      NULL,
      1.181999,
      1.967394,
      NULL,
      82.194820,
      81,
      42.424503,
      146,
      NULL,
      ' 4-19-1984',
      32.603802,
      21,
      16.417667,
      NULL,
      121.402101,
      201.117254,
      ' 8-25-1989',
      NULL,
      1.483226,
      1,
      0.713500,
      1,
      NULL,
      2.176299,
      1.721700,
      1.226630,
      1,
      2.371904,
      1,
      1.853176,
      1,
      1.833462,
      1.897208,
      1.501632,
      1.409862,
      0.775525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 6-2000',
      35.807690,
      12,
      1.926586,
      9,
      NULL,
      NULL,
      ' 1-19-1984',
      0,
      1,
      NULL,
      1,
      5,
      143,
      NULL,
      7.451077,
      62,
      0,
      1.973871,
      NULL,
      ' 2-16-1978',
      18.210249,
      NULL,
      22,
      47,
      36,
      95,
      80.753135,
      44.439765,
      42.393941,
      53,
      NULL,
      NULL,
      NULL,
      20.148324,
      NULL,
      20,
      48,
      66.030847,
      73,
      8,
      ' 7- 6-2001',
      13.981781,
      3,
      ' 3- 0-1974',
      NULL,
      11.322179,
      8,
      0.229810,
      24.511285,
      NULL,
      1,
      19.858176,
      NULL,
      49.209587,
      0,
      5,
      14,
      25,
      NULL,
      0.730821,
      0,
      1.071659,
      '11-21-1989',
      3,
      1.638816,
      1.207010,
      ' 7- 5-1988',
      59.394915,
      0,
      NULL,
      25,
      13.162582,
      ' 1- 8-1997',
      17,
      ' 1-12-1978',
      NULL,
      ' 7-25-1981',
      11,
      1.887784,
      ' 9- 2-1996',
      25.881088,
      14,
      ' 9-14-1990',
      NULL,
      NULL,
      '11-22-1978',
      NULL,
      13.445960,
      ' 5- 5-2001',
      1,
      0,
      NULL,
      NULL,
      31.255881,
      43,
      32.819118,
      ' 1- 8-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11);
commit;
end;
/


