set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9662110';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1133',
      '14434000',
      NULL,
      '34343021',
      '40322414',
      '10133403',
      '23132304',
      NULL,
      '21000434',
      '10304311',
      NULL,
      '22303131',
      '32111312',
      '41430300',
      '13343241',
      '40303012',
      '31210304',
      NULL,
      '22100324',
      NULL,
      '33123420',
      '30231022',
      '10440442',
      '01132410',
      '43342240',
      NULL,
      '21134224',
      '41343014',
      '44343041',
      '21304141',
      '34042043',
      '04211011',
      '40011344',
      NULL,
      '23014133',
      '23403011',
      '01003334',
      '34104003',
      '40342200',
      '24214123',
      '30043323',
      '11123101',
      '22411333',
      NULL,
      NULL,
      '332',
      '34',
      14.147381,
      8,
      NULL,
      1.723568,
      NULL,
      1,
      NULL,
      '041221',
      4.024686,
      ' 4- 6-1975',
      ' 4-24-1998',
      73,
      72.220352,
      NULL,
      2,
      6.633755,
      24.605536,
      67,
      11,
      18.423990,
      6,
      NULL,
      NULL,
      36.306690,
      12.234998,
      31.731531,
      13.206050,
      23,
      10,
      66.935136,
      11.081282,
      NULL,
      11,
      78,
      4,
      1,
      120,
      NULL,
      110.727674,
      137.402492,
      266.201959,
      NULL,
      NULL,
      20.610549,
      43.740130,
      NULL,
      9.846908,
      77,
      NULL,
      ' 3-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.317735,
      13.967450,
      7.595857,
      NULL,
      NULL,
      8.217791,
      NULL,
      0,
      3.506824,
      119.638967,
      1.281301,
      NULL,
      55.049025,
      1.238777,
      5.055552,
      100.531646,
      NULL,
      NULL,
      NULL,
      ' 0-17-1997',
      14.164906,
      4.590325,
      83.554250,
      96,
      69,
      109,
      51,
      NULL,
      5.670793,
      19,
      4.871125,
      79,
      ' 9-11-1988',
      NULL,
      15.153510,
      18,
      37.323437,
      54.189612,
      NULL,
      NULL,
      ' 2- 0-2003',
      NULL,
      0,
      ' 2-21-1996',
      4,
      19,
      27,
      8,
      10,
      3,
      1.868016,
      20,
      1,
      76.253567,
      1.998706,
      1.098383,
      7,
      18,
      NULL,
      1.120415,
      NULL,
      1,
      ' 4- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      147.010885,
      NULL,
      '10-17-2002',
      NULL,
      NULL,
      NULL,
      14,
      ' 6-20-2003',
      11.519067,
      NULL,
      NULL,
      NULL,
      ' 3-29-1983',
      76.169029,
      NULL,
      ' 3-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      12.995909,
      ' 8-17-1991',
      NULL,
      6.971458,
      27.022060,
      '11-21-1988',
      1.160296,
      7,
      '11-21-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


