set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9811603';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '1',
      '1',
      '4',
      NULL,
      NULL,
      '3',
      '1',
      '0',
      '0',
      '0',
      '4',
      '0',
      NULL,
      NULL,
      '4',
      '1',
      '3',
      NULL,
      '2',
      '3',
      '0',
      '0',
      '',
      '0',
      NULL,
      '2',
      '0',
      '0',
      '3',
      '2',
      '',
      '',
      '1',
      '2',
      '4',
      '4',
      '2',
      '2',
      '3',
      NULL,
      '0',
      '1',
      '0',
      '204',
      '40403024',
      28.869387,
      20.435582,
      '2342423',
      2,
      1.018552,
      2,
      1,
      '202114',
      5,
      NULL,
      ' 5-21-1976',
      254,
      107,
      18,
      8,
      35,
      3.504429,
      32,
      9.175946,
      17,
      5.603527,
      39,
      15.061469,
      25,
      16.110350,
      26.047599,
      19.136420,
      5.528844,
      7,
      25,
      6,
      35,
      0.222533,
      95.542266,
      11.182777,
      NULL,
      NULL,
      38,
      5.753436,
      166.448121,
      142,
      69.394713,
      ' 1-11-1975',
      49.343307,
      71,
      19.750842,
      7,
      70,
      118,
      ' 9- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      NULL,
      2.172904,
      6,
      3,
      3,
      ' 0- 8-1994',
      0.909957,
      1,
      NULL,
      0.711189,
      3,
      148,
      2,
      0.681150,
      43.655192,
      NULL,
      NULL,
      NULL,
      ' 9-26-2001',
      105.106136,
      46,
      12,
      107,
      65.095298,
      58.464267,
      107,
      107.898673,
      NULL,
      44,
      87.154848,
      83,
      ' 0-15-2003',
      NULL,
      13.267211,
      2.847015,
      26.341815,
      54,
      47.010698,
      4.717838,
      '10-15-1993',
      11.406680,
      0,
      NULL,
      2.400931,
      16,
      1.264055,
      8,
      15.542841,
      4.457224,
      0,
      1,
      0.004284,
      27,
      2.511827,
      0.713841,
      7,
      9.195152,
      NULL,
      0,
      0,
      1,
      ' 4- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      222.210858,
      1,
      ' 5-28-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.025144,
      NULL,
      11,
      NULL,
      ' 8- 8-1998',
      153.220564,
      61.522309,
      ' 1-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.237274,
      '10- 8-1996',
      55.863586,
      12.666928,
      7,
      '10-28-1999',
      1,
      NULL,
      ' 8-29-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


