set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537633';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40201203',
      '34344330',
      '30023224',
      '10434430',
      '33332414',
      '11101041',
      '21101140',
      '33330012',
      NULL,
      '20310120',
      '12202243',
      '24421311',
      '41023121',
      '40332112',
      '44334044',
      '03140341',
      NULL,
      '14211440',
      '01113020',
      '24034431',
      '20214103',
      NULL,
      '22201140',
      NULL,
      '42320133',
      '03332111',
      NULL,
      NULL,
      NULL,
      '24133234',
      '40004344',
      NULL,
      '21123141',
      '40342024',
      '01221402',
      '21324430',
      '04223024',
      '34421433',
      '44414243',
      '40214200',
      NULL,
      '12031232',
      NULL,
      '04301403',
      NULL,
      '42',
      NULL,
      NULL,
      NULL,
      1.583891,
      0,
      0,
      NULL,
      '003410',
      4,
      ' 5-13-1986',
      ' 7-10-2000',
      50.179205,
      NULL,
      28,
      14.914202,
      6.927809,
      7,
      8,
      7.915164,
      25,
      NULL,
      NULL,
      20.323392,
      2.547893,
      NULL,
      NULL,
      17.884130,
      NULL,
      13.705181,
      NULL,
      15.234181,
      1,
      21.734817,
      45.912822,
      1.519191,
      1.995432,
      106.749429,
      13.893789,
      127,
      150.362402,
      169.314102,
      208,
      ' 7- 2-1994',
      2,
      NULL,
      8,
      31,
      218,
      85.647486,
      ' 8- 9-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.486683,
      NULL,
      7.567864,
      7,
      NULL,
      6,
      ' 7-21-1987',
      0.507874,
      NULL,
      211.038342,
      NULL,
      0.864127,
      69.667451,
      1.499509,
      1,
      0,
      NULL,
      NULL,
      NULL,
      ' 2-22-1978',
      6,
      43,
      76,
      26,
      54.081789,
      81.365364,
      NULL,
      1.432071,
      31,
      61.341999,
      31.538063,
      63,
      ' 8-22-1991',
      18,
      30,
      26.136060,
      66.460836,
      47,
      62.274493,
      8.756385,
      NULL,
      10.752395,
      16.614280,
      ' 9-13-1983',
      2.063795,
      NULL,
      28.434735,
      14.346471,
      16,
      NULL,
      0.438143,
      NULL,
      1.642880,
      11.716101,
      0.939145,
      3.637744,
      31.500674,
      31.610866,
      0,
      1,
      1,
      0.644339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      282,
      NULL,
      '10- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.860776,
      ' 0-24-1976',
      1.226443,
      NULL,
      ' 6-10-1976',
      6,
      61.449648,
      '11-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      19,
      ' 6-23-1994',
      73.402319,
      NULL,
      44,
      '11-20-1983',
      NULL,
      20.273434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


