set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9537633';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3424',
      NULL,
      '42122412',
      '11120231',
      '44302423',
      '13200412',
      '22333132',
      '10343140',
      '02232412',
      '22033341',
      '03210103',
      '42234200',
      '10031013',
      '30231424',
      '32013002',
      '10330334',
      NULL,
      '24032100',
      '44011443',
      NULL,
      '10142212',
      '40001010',
      '13120230',
      NULL,
      '34222022',
      NULL,
      '31433144',
      '24311340',
      '20241223',
      NULL,
      '23033310',
      '43231143',
      NULL,
      '32441302',
      NULL,
      '03011101',
      '44202233',
      '41444203',
      NULL,
      NULL,
      '43322030',
      '32043231',
      NULL,
      '42321323',
      '33023314',
      '004',
      '12',
      29.725028,
      20.781436,
      NULL,
      3.873904,
      0.384781,
      2,
      NULL,
      '434334',
      4,
      '11-23-1994',
      NULL,
      15.463422,
      19,
      42,
      25.709882,
      3.791064,
      8.454590,
      33,
      24,
      33,
      15,
      NULL,
      27,
      17.139829,
      1.396469,
      8.598918,
      13.980745,
      13,
      32,
      44.748696,
      12,
      26,
      11.145624,
      NULL,
      31,
      0.518980,
      NULL,
      NULL,
      NULL,
      88.500263,
      166,
      179.451848,
      NULL,
      NULL,
      4,
      27,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      15.139435,
      4,
      9,
      5,
      7.138290,
      ' 0- 7-1994',
      1.203261,
      0.479814,
      55.258261,
      1,
      1,
      61.335176,
      4.577601,
      NULL,
      53.216069,
      NULL,
      NULL,
      NULL,
      ' 7-15-2001',
      33,
      48.846477,
      36,
      NULL,
      70.848731,
      89,
      66,
      NULL,
      NULL,
      4,
      NULL,
      61,
      ' 2-28-1998',
      NULL,
      NULL,
      38.138922,
      NULL,
      102.560605,
      167,
      9.204396,
      '11- 4-1990',
      15.740778,
      NULL,
      NULL,
      13.827671,
      11.315343,
      NULL,
      NULL,
      22,
      11,
      1.316065,
      26.471348,
      0,
      2.833533,
      1,
      0.895492,
      31,
      30,
      0,
      0,
      1.419764,
      0,
      ' 2-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-2000',
      5.319485,
      ' 4- 5-2003',
      3,
      NULL,
      '10-29-1978',
      NULL,
      85.873459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      23.364626,
      ' 1-12-2002',
      54.419573,
      51.645163,
      50.142148,
      ' 2-26-1998',
      1,
      56.920095,
      ' 4-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


