set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9034976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3243',
      '20034143',
      '33120023',
      '10230320',
      NULL,
      '11412130',
      '40414202',
      '41213411',
      '01101423',
      NULL,
      NULL,
      '43000442',
      '12300430',
      '04230302',
      NULL,
      '11200344',
      '43103134',
      '01112212',
      '00024144',
      '13104211',
      '04140420',
      '30302340',
      NULL,
      '20414311',
      '22441244',
      '24114211',
      NULL,
      '31320423',
      '12010034',
      '10121430',
      '24121430',
      NULL,
      '10224130',
      '04020330',
      '23302133',
      NULL,
      '10314240',
      '12420111',
      NULL,
      NULL,
      '42213204',
      '12000211',
      '33420431',
      '24023333',
      '44321311',
      '233',
      '22',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      ' 2- 2-1985',
      ' 0- 3-1996',
      39,
      NULL,
      22.073442,
      6,
      2,
      8,
      13,
      11.940474,
      NULL,
      NULL,
      18.307046,
      NULL,
      5,
      0,
      5.612383,
      NULL,
      5.431926,
      2,
      1,
      NULL,
      29.431497,
      5.468415,
      16.060637,
      NULL,
      0,
      12.561686,
      72,
      41,
      70.807176,
      22.420275,
      59.989713,
      NULL,
      20.593497,
      6,
      22,
      10.795582,
      116.043384,
      74.009821,
      NULL,
      NULL,
      16,
      15,
      2,
      2.005162,
      0,
      3,
      3.148175,
      3,
      NULL,
      6.106717,
      3.385867,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      1.160997,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1990',
      9,
      34.203158,
      38,
      0.651366,
      31.423978,
      2.250364,
      ' 8-25-1987',
      0,
      0.736137,
      65,
      0.170831,
      1,
      78.719881,
      1.814639,
      0.699320,
      NULL,
      NULL,
      0,
      113.359139,
      NULL,
      29,
      40.135755,
      34.461381,
      32.911505,
      11.751542,
      22.455905,
      NULL,
      0,
      38,
      17.852074,
      2.252245,
      23,
      ' 6-19-1986',
      19,
      11.861871,
      NULL,
      NULL,
      NULL,
      19.130128,
      2,
      NULL,
      26,
      5.206088,
      ' 8- 4-1986',
      5,
      9,
      16,
      2.242153,
      5.361945,
      1,
      1,
      3.925790,
      1.586441,
      62.186837,
      NULL,
      0.554815,
      NULL,
      10,
      NULL,
      NULL,
      1.600493,
      0,
      NULL,
      0.039360,
      1,
      1,
      '11-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1985',
      NULL,
      ' 5- 4-1996',
      13,
      5.364475,
      ' 2- 4-1994',
      17,
      33,
      ' 8- 7-1983',
      3.290646,
      10,
      ' 9- 3-2002',
      0.414944,
      0.126248,
      ' 1- 9-1998',
      NULL,
      NULL,
      NULL,
      ' 0-29-1975',
      18,
      15.315253,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


