set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2041',
      '34040032',
      NULL,
      '22443031',
      '30201412',
      '11142432',
      NULL,
      '42220312',
      '10303431',
      NULL,
      '32120343',
      '13321400',
      '12231143',
      NULL,
      '31244303',
      '02113404',
      '41313210',
      '14044104',
      '23444124',
      '24132211',
      '21001443',
      '23234224',
      '11100332',
      '02214300',
      '24133334',
      '13400014',
      '02003223',
      '04203134',
      '34122112',
      '34110443',
      '12000033',
      '11310211',
      '33043330',
      '10413414',
      '30224304',
      '24124300',
      NULL,
      '32313022',
      '00142243',
      '04120332',
      NULL,
      '24314132',
      '42032030',
      '23041344',
      '31034424',
      '',
      NULL,
      NULL,
      NULL,
      '3330024',
      1,
      NULL,
      3,
      NULL,
      '342122',
      NULL,
      NULL,
      ' 9-14-1976',
      48.756634,
      NULL,
      25.386409,
      NULL,
      21.910138,
      NULL,
      21.495355,
      21,
      21.227275,
      14,
      40,
      4.247287,
      35.302664,
      NULL,
      15,
      10,
      NULL,
      20.751886,
      4.305652,
      12.446752,
      NULL,
      1.065038,
      25.586626,
      2,
      NULL,
      76.756100,
      97.443576,
      109,
      178.372980,
      62.833631,
      24.471305,
      ' 1-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953537,
      0.576600,
      0.591693,
      1.331036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1992',
      NULL,
      NULL,
      NULL,
      61,
      73.358379,
      94.394546,
      34.144150,
      69.945306,
      41,
      NULL,
      NULL,
      38.240251,
      ' 3-22-1980',
      16.914293,
      12.342811,
      24.996734,
      NULL,
      81,
      21.143963,
      4,
      NULL,
      3.759676,
      NULL,
      NULL,
      NULL,
      NULL,
      24.154412,
      15.648408,
      NULL,
      10.977157,
      NULL,
      1,
      NULL,
      57.149066,
      0.594010,
      1.504132,
      11.311332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.172029,
      NULL,
      1.780569,
      ' 5-20-1996',
      0,
      349,
      ' 4-28-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120798,
      14,
      7.421594,
      NULL,
      97,
      15,
      10,
      1.390404,
      5.861915,
      11,
      NULL,
      0,
      1.761558,
      15,
      1.148243,
      0,
      44.731395,
      1,
      0,
      122.562657,
      1,
      3.289441,
      181.333964,
      32,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.617359,
      NULL,
      NULL,
      NULL,
      88.021520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374792,
      72.182329,
      1.530118,
      5.893324,
      75.108717,
      12.064508,
      13,
      13,
      6,
      96,
      NULL,
      NULL,
      12,
      4,
      NULL,
      5.250754,
      0,
      1,
      NULL,
      1,
      101,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1992',
      NULL,
      ' 8-28-1999',
      NULL);
commit;
end;
/


