set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0330',
      '43204334',
      '22234213',
      '34413104',
      '24243211',
      NULL,
      '42241321',
      '23214213',
      NULL,
      '31141344',
      '11234443',
      '41304134',
      NULL,
      '34020114',
      '31324404',
      '23212031',
      '32210202',
      NULL,
      '34033211',
      '02331000',
      '04133102',
      '41234411',
      '40134330',
      '02241422',
      NULL,
      '44221322',
      '13022424',
      '14433322',
      '30201014',
      NULL,
      '24433320',
      '31124032',
      '34413341',
      '20121044',
      NULL,
      '14241312',
      '00404400',
      '33232111',
      NULL,
      '04103210',
      NULL,
      '41300112',
      '34302113',
      '13141122',
      NULL,
      '022',
      NULL,
      NULL,
      NULL,
      '2414003',
      2.275189,
      16,
      1,
      NULL,
      NULL,
      1,
      ' 8-26-1984',
      ' 3-27-2002',
      NULL,
      NULL,
      NULL,
      13,
      30,
      1,
      NULL,
      2,
      26.760457,
      22.934696,
      NULL,
      NULL,
      44.602903,
      13.586524,
      NULL,
      23.851190,
      12.242613,
      21.348638,
      28,
      9.172381,
      41.141230,
      NULL,
      42,
      9.704164,
      1,
      25,
      118,
      37.923572,
      102,
      238.100789,
      NULL,
      ' 1-27-1982',
      33.820270,
      29,
      23,
      12,
      106.581770,
      115.261911,
      '10-27-1974',
      1.710830,
      0.112291,
      1.435341,
      NULL,
      5.693563,
      0,
      4,
      NULL,
      0.858510,
      1,
      NULL,
      1.885588,
      0.832019,
      NULL,
      1,
      1.297916,
      3.267209,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.628921,
      4.225330,
      1.637187,
      NULL,
      NULL,
      1,
      NULL,
      202,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1979',
      5.828969,
      23,
      0.511141,
      66.070493,
      NULL,
      42,
      116.360705,
      16,
      7.740641,
      33,
      NULL,
      28.203816,
      ' 5- 1-1996',
      NULL,
      NULL,
      20.132084,
      57,
      NULL,
      NULL,
      1.385974,
      NULL,
      NULL,
      8,
      NULL,
      10.698304,
      4,
      NULL,
      0.374144,
      NULL,
      6,
      1.583744,
      20,
      0.480828,
      NULL,
      NULL,
      4,
      NULL,
      24.768082,
      1,
      1,
      0.110297,
      2,
      ' 4-23-1986',
      4,
      1.627821,
      2,
      ' 1-13-1982',
      54.991989,
      61,
      ' 4-10-1988',
      NULL,
      NULL,
      NULL,
      12,
      ' 2-24-1978',
      35.282840,
      NULL,
      12.166293,
      2,
      '11-29-2001',
      NULL,
      NULL,
      NULL,
      6,
      3,
      ' 7-19-2002',
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 9-28-1977',
      16.134291,
      0.279753,
      2.425766,
      ' 5-14-1980',
      1.772385,
      108.806514,
      '10-26-1987',
      10,
      NULL,
      17.619047,
      NULL,
      ' 5- 4-1982',
      NULL,
      NULL,
      47.591909,
      ' 0-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8);
commit;
end;
/


