set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14444114',
      '04224333',
      NULL,
      NULL,
      NULL,
      '22303101',
      '01303341',
      '21201234',
      '21212121',
      '24013404',
      '01341203',
      '31343000',
      '41130112',
      NULL,
      '34144140',
      NULL,
      NULL,
      '44412203',
      '10422433',
      '22131221',
      NULL,
      '33410312',
      NULL,
      '33131122',
      NULL,
      '12101104',
      '01322000',
      '12040434',
      '23244022',
      '13432020',
      '21013231',
      '34222130',
      '01412431',
      '34102143',
      NULL,
      NULL,
      NULL,
      '11202442',
      NULL,
      '11133231',
      NULL,
      NULL,
      '33402441',
      '10223033',
      '030',
      '12',
      NULL,
      14,
      '0433132',
      2,
      NULL,
      2,
      NULL,
      '034433',
      2.793622,
      NULL,
      ' 1-15-1996',
      16,
      NULL,
      NULL,
      12,
      27,
      20.341817,
      71,
      NULL,
      5.998980,
      NULL,
      30.600404,
      12,
      2.371085,
      2.612749,
      33.637205,
      7.249022,
      20.422339,
      NULL,
      43,
      NULL,
      20,
      12,
      23.306012,
      21,
      1.341854,
      NULL,
      NULL,
      15,
      117,
      131.749158,
      146.037324,
      NULL,
      29,
      43,
      16,
      14,
      21.352707,
      93.567525,
      ' 4- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.405164,
      14,
      11.310414,
      2.660482,
      6.580447,
      1,
      ' 0-20-1974',
      0.751419,
      0.754661,
      2.105503,
      NULL,
      1.833243,
      86.544362,
      0.228645,
      0.839652,
      73,
      NULL,
      NULL,
      NULL,
      ' 1- 8-1975',
      NULL,
      57.720340,
      14.597197,
      26,
      88.054580,
      16,
      NULL,
      NULL,
      42.463984,
      63,
      73,
      53.850207,
      ' 8-17-1985',
      15,
      24,
      17,
      39,
      46,
      39.208165,
      1.479544,
      NULL,
      34,
      NULL,
      ' 6- 0-2001',
      NULL,
      5,
      3,
      2.059623,
      28,
      7,
      1.667302,
      21,
      1.684903,
      43,
      NULL,
      NULL,
      23.731920,
      25.965742,
      4,
      1,
      3,
      1,
      ' 4- 8-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      31.938354,
      ' 3- 6-1976',
      NULL,
      NULL,
      NULL,
      11,
      '10- 5-1998',
      29,
      '10-25-1983',
      11.701150,
      13.572390,
      '11- 3-1986',
      92,
      114.900835,
      ' 4-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 2-28-1974',
      44,
      15.517089,
      NULL,
      ' 4-10-1974',
      0.092679,
      NULL,
      ' 8- 2-1985',
      0,
      34.644104,
      12.645126,
      NULL,
      ' 7-21-1999',
      19,
      0,
      94,
      ' 8-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


