set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      '0',
      '2',
      '4',
      NULL,
      '1',
      '3',
      '4',
      '4',
      '0',
      '4',
      '0',
      NULL,
      '0',
      '2',
      '0',
      '0',
      NULL,
      '2',
      NULL,
      '4',
      '0',
      '',
      NULL,
      '',
      '1',
      '2',
      '0',
      '0',
      '2',
      '',
      '',
      '2',
      '4',
      '3',
      NULL,
      '2',
      '3',
      '1',
      '2',
      '4',
      '1',
      '4',
      NULL,
      '13230000',
      15.304741,
      NULL,
      '1222200',
      0.412752,
      19.162657,
      2,
      NULL,
      NULL,
      5.320285,
      ' 3-29-1974',
      ' 0-18-1989',
      NULL,
      125,
      28,
      2.001333,
      34.245283,
      20,
      69.433789,
      NULL,
      8.178240,
      9,
      0,
      NULL,
      41.746984,
      7,
      12.552285,
      2.401679,
      5,
      0,
      35,
      5,
      57,
      5,
      81,
      3,
      0,
      86.636214,
      203.614830,
      61,
      39.069102,
      119,
      56.465125,
      ' 9-17-1996',
      19.863164,
      25,
      NULL,
      33,
      NULL,
      NULL,
      '11-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      4.559374,
      0,
      7,
      3,
      0.169013,
      '11- 7-1997',
      NULL,
      0,
      131.797970,
      NULL,
      0.339599,
      128.987987,
      1.960948,
      1,
      5,
      NULL,
      NULL,
      NULL,
      ' 7-20-1994',
      0.308392,
      64.952006,
      25,
      29.948385,
      NULL,
      77.826932,
      41.557521,
      NULL,
      NULL,
      57.907259,
      58.894364,
      16,
      ' 6-16-1976',
      0,
      7.372559,
      26,
      NULL,
      NULL,
      65.593194,
      12.250571,
      ' 0-15-1991',
      1,
      16,
      ' 8- 6-1985',
      11.307864,
      7,
      16.531815,
      NULL,
      NULL,
      0,
      0.075013,
      8,
      NULL,
      99.386729,
      1,
      1,
      NULL,
      24.344339,
      1.434169,
      1,
      NULL,
      1,
      ' 0- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.727345,
      ' 6-18-1995',
      NULL,
      NULL,
      NULL,
      19.548877,
      ' 3-29-1994',
      19.428981,
      ' 1- 3-1987',
      1,
      7.239823,
      ' 0-21-1987',
      36.436434,
      34.809305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      17.710702,
      ' 1- 1-1980',
      NULL,
      18,
      10.294589,
      ' 6-24-1991',
      0,
      7.282924,
      '10- 8-1979',
      10.681108,
      32,
      20,
      27.175183,
      NULL,
      30,
      0.346955,
      45.659427,
      '11-22-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


