set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6111740';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '42303433',
      NULL,
      '14002141',
      '00322020',
      '04331001',
      '03313102',
      '02212224',
      '13443131',
      NULL,
      '14111030',
      NULL,
      NULL,
      '04032024',
      '00222342',
      '44443301',
      '00100400',
      '34140130',
      NULL,
      NULL,
      '40000024',
      '41304444',
      '13142220',
      '10124100',
      '20240112',
      '10442414',
      '00403114',
      NULL,
      '33103033',
      NULL,
      '24443412',
      '44231000',
      '04303402',
      '20111040',
      '42033430',
      NULL,
      NULL,
      '23112121',
      NULL,
      '44123340',
      '23104213',
      '42300241',
      '31441234',
      '04342311',
      NULL,
      '32',
      NULL,
      NULL,
      '3344110',
      1,
      0,
      0,
      NULL,
      '344013',
      NULL,
      ' 1-10-1997',
      '10- 0-1986',
      17,
      NULL,
      NULL,
      1,
      38,
      9.150322,
      37.624993,
      4,
      3,
      19.883685,
      18,
      NULL,
      28,
      2.927502,
      0,
      NULL,
      NULL,
      7.158237,
      15,
      7,
      33,
      19,
      16.691397,
      10,
      1.419689,
      7,
      145.166492,
      7,
      133,
      126,
      32.011106,
      ' 7-29-1997',
      33.114609,
      54,
      11,
      NULL,
      8,
      218,
      ' 7- 5-1992',
      0,
      6.848810,
      1,
      2,
      1.004558,
      1,
      NULL,
      NULL,
      0.953971,
      0.201489,
      NULL,
      1.501631,
      1,
      1.274410,
      1.258142,
      0,
      3.935758,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-2003',
      96.256818,
      18.093297,
      NULL,
      NULL,
      4,
      2.222478,
      ' 0-27-1977',
      NULL,
      0.066454,
      NULL,
      NULL,
      1,
      57,
      1.072020,
      0,
      40.155063,
      NULL,
      NULL,
      NULL,
      ' 2- 8-2003',
      NULL,
      45,
      NULL,
      46.511160,
      85,
      33,
      75,
      5,
      105,
      36,
      24,
      93.825004,
      ' 6-10-1985',
      5,
      30.327207,
      10,
      2,
      10,
      NULL,
      NULL,
      ' 5- 7-1995',
      0.755404,
      15,
      NULL,
      2,
      14.634141,
      NULL,
      21.065434,
      10,
      9,
      1.610303,
      19,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      3.001492,
      1.607972,
      '11- 8-2002',
      6,
      2.783873,
      3.529762,
      ' 6-10-1984',
      188,
      0,
      ' 6-28-1984',
      10,
      3,
      ' 1- 9-1986',
      NULL,
      NULL,
      18.184991,
      ' 8-10-1990',
      15.819353,
      5.150633,
      ' 2- 2-1986',
      29,
      3.193530,
      ' 8-16-2000',
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      67,
      6.345233,
      18,
      ' 0-21-1994',
      1,
      21,
      '10- 7-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12);
commit;
end;
/


