set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7526922';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1141',
      '31411434',
      '40101020',
      '21410213',
      '10341232',
      '23423044',
      NULL,
      '24403200',
      '33423043',
      '03131011',
      '31421233',
      NULL,
      NULL,
      NULL,
      NULL,
      '23110222',
      '13141042',
      NULL,
      '30340010',
      '31124112',
      '11413323',
      '34301033',
      '23223443',
      '40231323',
      '14332140',
      NULL,
      NULL,
      '32432111',
      '42244413',
      NULL,
      '30322210',
      '34014104',
      '02221313',
      '31202012',
      NULL,
      '34043031',
      NULL,
      NULL,
      '11034330',
      '32433320',
      '01202314',
      '04410413',
      '10243110',
      '41103003',
      NULL,
      NULL,
      '13',
      NULL,
      NULL,
      '0222144',
      0.720328,
      1.668614,
      NULL,
      NULL,
      '104104',
      2,
      NULL,
      ' 0- 4-1999',
      94,
      NULL,
      NULL,
      1.712866,
      22.785620,
      11.351117,
      9.962965,
      2,
      NULL,
      NULL,
      NULL,
      11.345077,
      9,
      9.690656,
      NULL,
      13.457924,
      NULL,
      NULL,
      40,
      13.661859,
      0.605206,
      NULL,
      21,
      3,
      NULL,
      62,
      158.894823,
      NULL,
      64.721639,
      57,
      167.072334,
      ' 1-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1982',
      30.904304,
      15.976123,
      15,
      NULL,
      NULL,
      6.969255,
      52,
      68.634015,
      20.172308,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1985',
      11,
      2.726492,
      7,
      NULL,
      36.016714,
      NULL,
      5.195080,
      ' 3-15-1989',
      0,
      2,
      ' 1- 9-2002',
      6.427642,
      NULL,
      14.284753,
      6,
      1.958691,
      3.676296,
      1,
      10.895355,
      NULL,
      NULL,
      8.266752,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      8,
      2,
      NULL,
      2,
      149,
      ' 2- 2-2003',
      13.922059,
      20,
      11,
      45.238495,
      ' 3-22-2002',
      37.843600,
      1.312957,
      46.364986,
      ' 4-19-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      12.470330,
      NULL,
      3.810620,
      9,
      NULL,
      0.134458,
      0.989181,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602753,
      0.758725,
      45,
      0,
      1.152003,
      NULL,
      NULL,
      10.428901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.210188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      9.281007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.318667,
      19,
      NULL,
      8.397406,
      4,
      1.385904,
      0,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1976',
      NULL,
      NULL,
      ' 1- 2-1976',
      NULL,
      ' 5- 4-1990',
      NULL);
commit;
end;
/


