set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9426330';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1403',
      NULL,
      NULL,
      '30043130',
      '01300044',
      '43001221',
      '33120101',
      '31214232',
      NULL,
      '13332324',
      '21230334',
      '03211122',
      NULL,
      '43024204',
      '21434120',
      '31242244',
      '34344220',
      NULL,
      '02303332',
      '24233023',
      '11013134',
      NULL,
      '02040402',
      NULL,
      '33042103',
      '32441301',
      '22122240',
      '32143041',
      '24040104',
      '12014102',
      '41232130',
      '42411304',
      '22301004',
      NULL,
      '42341411',
      '21322112',
      '42304233',
      '12212404',
      NULL,
      NULL,
      '34203404',
      '32131211',
      '44203014',
      '30213421',
      '21144310',
      '114',
      '42',
      NULL,
      NULL,
      '4443441',
      NULL,
      1.243815,
      1,
      NULL,
      '224200',
      3.683832,
      ' 7-11-2003',
      '11-28-1979',
      21.116499,
      NULL,
      NULL,
      1,
      15,
      16.411018,
      60,
      6.641660,
      3.052200,
      2,
      29.089074,
      NULL,
      29,
      5.431826,
      6.910870,
      6,
      7,
      5,
      44,
      2,
      4,
      2,
      33,
      9.819642,
      1,
      89.732426,
      78,
      57,
      111,
      2.315266,
      92.849395,
      ' 1-19-1988',
      26,
      NULL,
      10,
      6,
      NULL,
      35.108164,
      ' 5- 1-2000',
      4,
      6,
      5.212275,
      7,
      0.703620,
      2,
      NULL,
      0.580241,
      1,
      NULL,
      7.485903,
      0.265800,
      0.256038,
      0,
      1.842936,
      1,
      1.982411,
      1,
      1.018795,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 0-2001',
      50,
      2,
      NULL,
      NULL,
      13.385852,
      3,
      ' 0-12-1980',
      NULL,
      0.378190,
      108.907958,
      3,
      0.623491,
      NULL,
      1,
      1.474534,
      9.307036,
      NULL,
      NULL,
      NULL,
      '11-13-2002',
      NULL,
      32.369234,
      51,
      34,
      74,
      52,
      NULL,
      9.297530,
      20,
      34.590523,
      21.231941,
      28,
      NULL,
      4.909738,
      NULL,
      11.105370,
      NULL,
      14.975434,
      66.891893,
      3,
      ' 0- 5-1996',
      1,
      6,
      ' 2- 0-2003',
      1,
      5,
      NULL,
      10.644940,
      NULL,
      NULL,
      0,
      9.447398,
      1.612996,
      23.923273,
      6,
      NULL,
      3.245046,
      17,
      4.134886,
      NULL,
      2,
      5.962599,
      ' 1- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      ' 7- 1-1988',
      NULL,
      NULL,
      NULL,
      5.057100,
      '11-22-1990',
      NULL,
      ' 0-19-1974',
      11,
      8.127465,
      ' 9- 9-2001',
      NULL,
      NULL,
      NULL,
      8.238225,
      4,
      ' 1-29-1993',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 0-15-1981',
      45,
      22.810369,
      2.684307,
      ' 4-22-2003',
      NULL,
      302.003285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


