set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04324434',
      NULL,
      '11402440',
      '23431204',
      '20102404',
      '01303020',
      NULL,
      NULL,
      NULL,
      '11032320',
      '10030313',
      '34412344',
      '34002131',
      '31424321',
      '04220212',
      NULL,
      '12401404',
      '23223112',
      NULL,
      '10013301',
      '34304303',
      '43344122',
      '02021141',
      '02400214',
      '22444310',
      NULL,
      '12043440',
      NULL,
      '14330122',
      '11013442',
      NULL,
      '31010003',
      NULL,
      '31243011',
      '11431324',
      '03341433',
      '10430120',
      '43114030',
      '04242010',
      '03103442',
      '14334410',
      '32044144',
      '12000101',
      '24003432',
      '244',
      '04',
      NULL,
      NULL,
      '0134300',
      0.127576,
      0,
      0,
      NULL,
      '233332',
      1.809038,
      ' 7- 9-1989',
      ' 2-24-2001',
      97.532399,
      NULL,
      21.643061,
      1.100460,
      25.062660,
      12.520808,
      NULL,
      6.244592,
      24,
      1,
      39.313099,
      21.849822,
      16,
      NULL,
      14,
      4.995859,
      9.062095,
      15.871769,
      NULL,
      17,
      24.821739,
      5.002372,
      20,
      6.775531,
      0.032487,
      64.739563,
      139.549739,
      34.190576,
      94.265800,
      4.136238,
      170.615456,
      ' 3- 4-1996',
      16.642465,
      7,
      38.881536,
      24,
      138,
      40.586733,
      ' 2-26-1985',
      0,
      2,
      NULL,
      14.610540,
      1.737413,
      96.339412,
      1.648169,
      22.357152,
      1.031575,
      0,
      3.215817,
      0.670427,
      1,
      5,
      NULL,
      1.502244,
      108.353399,
      NULL,
      0,
      64.805279,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-2001',
      75,
      10,
      5,
      0.881655,
      6.769820,
      8,
      ' 6-28-1982',
      0.699107,
      NULL,
      69.033804,
      1,
      1,
      31,
      NULL,
      0.392598,
      44.312306,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      11,
      52,
      45.307824,
      31.935283,
      NULL,
      10.589560,
      38.457291,
      48.164345,
      32,
      NULL,
      23.222619,
      ' 9- 6-1994',
      39,
      NULL,
      NULL,
      12.107690,
      107,
      2.079321,
      2,
      ' 4-21-1999',
      7.237415,
      0,
      ' 6-22-2003',
      12,
      15.846538,
      13.113834,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      4.221216,
      1,
      0.196011,
      17.468929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 9-1997',
      14,
      ' 4-11-1988',
      6.813781,
      5,
      ' 6-13-1987',
      NULL,
      NULL,
      NULL,
      1.964874,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.933403,
      '10-29-1977',
      22.223328,
      NULL,
      8.862828,
      ' 1-27-2002',
      3,
      NULL,
      ' 4-24-2000',
      6,
      40.843668,
      1.203390,
      47.159558,
      ' 1-25-1993',
      62,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


