set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9003604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3243',
      '22312442',
      NULL,
      NULL,
      NULL,
      '41243112',
      '33434033',
      '22000301',
      NULL,
      '31311334',
      '40001110',
      '23441434',
      '12330400',
      '04333344',
      '40243423',
      '43303044',
      '03043133',
      NULL,
      '13222021',
      '11223341',
      NULL,
      '40020212',
      '01340401',
      '04244012',
      '20131140',
      '40214401',
      NULL,
      '03331023',
      '12004423',
      '12004300',
      NULL,
      '00431010',
      NULL,
      NULL,
      '04240130',
      '21020033',
      '12132422',
      '04200234',
      NULL,
      '02201133',
      '30341244',
      NULL,
      '30420343',
      '12042444',
      '01412444',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3.689359,
      0,
      NULL,
      NULL,
      '112223',
      NULL,
      ' 3- 1-1982',
      '11- 1-1998',
      3,
      NULL,
      1.062035,
      3.789643,
      0,
      8,
      86,
      15,
      NULL,
      11,
      47.069129,
      22,
      11.887910,
      15,
      3,
      2,
      5.398442,
      23,
      86.247756,
      4,
      2,
      15,
      123,
      13.189437,
      NULL,
      9.488437,
      118.180420,
      NULL,
      52.825951,
      194.925792,
      NULL,
      ' 3- 3-1994',
      49,
      NULL,
      24,
      14.342372,
      77,
      35.332664,
      ' 6-11-1977',
      1,
      0,
      NULL,
      1.871175,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616539,
      NULL,
      NULL,
      1.711994,
      0,
      0.502099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      164,
      14.862738,
      NULL,
      104.302780,
      6.471168,
      4.735703,
      33,
      63,
      8.719237,
      NULL,
      29,
      34,
      ' 6-10-1981',
      0.861255,
      NULL,
      4.128196,
      1.835276,
      1,
      121,
      NULL,
      '10-11-1999',
      8,
      15,
      ' 0-10-1995',
      NULL,
      9,
      NULL,
      10.576090,
      2.299623,
      NULL,
      NULL,
      2.206747,
      NULL,
      40.343732,
      3.082168,
      9,
      15.292929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      '10-17-1979',
      0,
      78.114149,
      ' 1-25-1981',
      5,
      4,
      18.556684,
      0.809980,
      ' 1-22-1981',
      2.468595,
      1,
      38.664976,
      ' 6-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      0.846175,
      18,
      NULL,
      NULL,
      85,
      16.464156,
      3,
      2,
      6.042632,
      NULL,
      NULL,
      NULL,
      0.349489,
      0.518909,
      1,
      0.902275,
      3.760216,
      0,
      1,
      74,
      0.646197,
      0.707945,
      96.577514,
      NULL,
      16,
      NULL,
      0,
      NULL,
      1,
      0.105423,
      1.871210,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121749,
      1,
      58,
      NULL,
      1,
      NULL,
      77,
      1.401259,
      NULL,
      0.561655,
      NULL,
      1,
      4.444694,
      NULL,
      34.991322,
      10.091298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      2,
      NULL,
      NULL,
      NULL,
      0.391622,
      0,
      0,
      NULL,
      ' 2-18-1992',
      NULL,
      ' 4-11-1985',
      NULL,
      ' 8- 0-2003',
      '10-29-1976',
      ' 8-11-1982',
      NULL);
commit;
end;
/


