set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9225492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43402311',
      '04420034',
      NULL,
      '31301432',
      NULL,
      '32242003',
      '03244042',
      NULL,
      '44214234',
      '31203332',
      NULL,
      '33101302',
      '11210040',
      '41230402',
      '03131421',
      '23000302',
      '23104134',
      '34130103',
      '10324303',
      '31104314',
      '34143102',
      '20033420',
      '21204001',
      '33202100',
      NULL,
      '00231123',
      '00041424',
      '10111014',
      '13442333',
      '41143320',
      '11322401',
      NULL,
      '20321344',
      '42211434',
      '00340033',
      '44201241',
      NULL,
      '43322100',
      NULL,
      NULL,
      '44112004',
      '02141140',
      NULL,
      '00410130',
      '420',
      '40',
      NULL,
      NULL,
      '2242224',
      3.699782,
      0.303611,
      2,
      NULL,
      '420012',
      NULL,
      ' 2-23-1988',
      NULL,
      37,
      NULL,
      42,
      11,
      12,
      17.213985,
      65.596632,
      13.156794,
      28.233134,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      19.975937,
      NULL,
      20.609687,
      32,
      61,
      3,
      24,
      6,
      NULL,
      2.137737,
      1.519322,
      126,
      NULL,
      101,
      181,
      96,
      107.594522,
      ' 6-25-1997',
      49,
      24,
      10,
      33,
      161.614226,
      39.697498,
      '11-13-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.899454,
      8,
      ' 3-24-1976',
      NULL,
      0,
      35,
      1.028296,
      1,
      99,
      1.112412,
      0,
      39,
      1,
      1.404698,
      76.320069,
      NULL,
      82.793442,
      20,
      86,
      38,
      52,
      96,
      NULL,
      NULL,
      7.118127,
      57.144214,
      12,
      47,
      NULL,
      3,
      7,
      29,
      15,
      33.236192,
      NULL,
      7,
      ' 3- 0-1991',
      38.452994,
      17.590426,
      ' 9- 7-1984',
      4,
      12.694970,
      23.022226,
      10,
      9.188403,
      9.625192,
      0.323170,
      NULL,
      1.315088,
      57,
      NULL,
      17,
      NULL,
      NULL,
      0,
      0.298774,
      1,
      1,
      ' 0- 4-2001',
      7,
      0.508741,
      0,
      NULL,
      136.542852,
      6.973158,
      ' 2-21-1998',
      16,
      NULL,
      ' 0-26-1995',
      NULL,
      NULL,
      19.320331,
      '11-17-1983',
      2,
      2.495438,
      ' 9- 0-2003',
      45.694460,
      75.679203,
      ' 2-28-2001',
      4,
      4.023566,
      ' 8-22-1986',
      NULL,
      1,
      ' 7-17-1985',
      0,
      NULL,
      27,
      ' 3- 0-1997',
      31,
      23.249356,
      23,
      ' 3- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


