set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1201',
      '03211100',
      '10231234',
      '43322340',
      NULL,
      '02212231',
      '22414433',
      '32234340',
      NULL,
      '00344112',
      '42302312',
      '12434133',
      '41322044',
      '22214012',
      '31214414',
      '11034441',
      NULL,
      '43104344',
      '03221000',
      '04134122',
      NULL,
      '23233412',
      NULL,
      NULL,
      '01130403',
      '33310242',
      '20033224',
      NULL,
      '44001102',
      '34100344',
      NULL,
      '02432032',
      '01123341',
      '33123234',
      NULL,
      '43330421',
      '32042430',
      '34011440',
      '11434213',
      '32222033',
      '31001402',
      '23001100',
      '01103032',
      '33421423',
      '42222020',
      '201',
      '32',
      NULL,
      25,
      '4430440',
      2,
      1,
      2,
      NULL,
      '322042',
      0.302690,
      ' 7- 2-1998',
      ' 4- 6-1992',
      NULL,
      62.439913,
      12,
      12.135075,
      22.010098,
      3,
      125,
      24,
      NULL,
      5.152122,
      26.663571,
      26,
      33.112988,
      4.176259,
      30,
      13,
      32.684629,
      4.158851,
      9.888920,
      24.123052,
      53,
      12.750013,
      NULL,
      NULL,
      NULL,
      79,
      75,
      81.930346,
      NULL,
      197.313182,
      NULL,
      '10-10-1993',
      NULL,
      21.439903,
      5.295295,
      19,
      NULL,
      211,
      ' 9-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      12.481840,
      3,
      1,
      1.840802,
      NULL,
      '10- 7-2003',
      NULL,
      0,
      76.013467,
      0.106280,
      1,
      NULL,
      NULL,
      1.768207,
      97.697393,
      NULL,
      NULL,
      NULL,
      ' 5-28-1996',
      64,
      51.053647,
      103.770992,
      NULL,
      7,
      NULL,
      NULL,
      94,
      29,
      67.349966,
      84,
      24.317868,
      ' 4-22-1976',
      4,
      23,
      22,
      0.728570,
      84.674801,
      104,
      8.526462,
      ' 3-21-1979',
      28,
      13,
      ' 8-17-2000',
      4,
      7.279965,
      7,
      21.219793,
      9,
      7,
      1.004319,
      NULL,
      1,
      14.133265,
      NULL,
      1.348206,
      5.987110,
      18,
      0,
      0,
      3,
      0,
      ' 1- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      49.473164,
      1.090535,
      NULL,
      NULL,
      NULL,
      NULL,
      30.885191,
      ' 1-12-1976',
      2,
      ' 9- 5-1987',
      NULL,
      2.949654,
      ' 1- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 3- 7-1977',
      36,
      NULL,
      56.010306,
      ' 0-19-1988',
      0,
      39,
      ' 4-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


