set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7420791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2413',
      '11132001',
      '10301123',
      NULL,
      NULL,
      '20043333',
      '04222434',
      '14441024',
      '31222043',
      '10324001',
      '03213434',
      NULL,
      '02410040',
      '02113301',
      '31022320',
      '01411001',
      NULL,
      '03403303',
      '11440423',
      '40400012',
      NULL,
      '02404034',
      '30144222',
      '12243330',
      NULL,
      '34004302',
      NULL,
      '12241133',
      '20411223',
      '24431400',
      '33404213',
      '33204100',
      '02041331',
      '02342233',
      '14222232',
      '24120011',
      NULL,
      '01301342',
      '04341140',
      '24233223',
      '34241134',
      '42212331',
      '24244222',
      NULL,
      '12201421',
      '313',
      '10',
      NULL,
      NULL,
      '2341124',
      1.452389,
      0,
      NULL,
      NULL,
      '040201',
      2,
      ' 2- 5-1995',
      ' 6-27-1993',
      NULL,
      NULL,
      NULL,
      30.308892,
      29.354048,
      19.302753,
      59.203792,
      21,
      36.491711,
      20,
      17.845714,
      24,
      42,
      14.721638,
      12.550866,
      NULL,
      NULL,
      16.816145,
      NULL,
      16,
      7.347685,
      2,
      48.287115,
      13,
      0,
      60,
      24,
      NULL,
      91.443389,
      73.922014,
      58.378199,
      NULL,
      23.999672,
      36,
      13,
      27,
      177.804885,
      149,
      ' 6-28-1993',
      0.852292,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900490,
      7,
      0.173616,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-21-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-11-2002',
      48.144085,
      118.321605,
      95.646545,
      60.136155,
      39.668419,
      51.812953,
      97.948525,
      19.299187,
      44.953235,
      3.531498,
      44.801331,
      72.535106,
      ' 6- 5-1978',
      7,
      16,
      16,
      26,
      25.241768,
      70.890832,
      6.875917,
      ' 7- 6-2000',
      12.943597,
      10,
      ' 6-20-2003',
      10.708534,
      5.171359,
      5.766182,
      0.554907,
      19,
      NULL,
      0,
      NULL,
      0.845886,
      42.365091,
      2,
      0.211948,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      13.280791,
      33,
      ' 2-17-1985',
      1.729682,
      NULL,
      NULL,
      8.145173,
      NULL,
      21,
      2,
      ' 9-28-1993',
      NULL,
      NULL,
      34.414151,
      ' 2-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068773,
      NULL,
      NULL,
      111.025965,
      0,
      NULL,
      3.104521,
      8.070623,
      5,
      NULL,
      1,
      1,
      40,
      1,
      1,
      59.830359,
      0,
      3,
      181,
      5.076783,
      1.286995,
      13.265411,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      0,
      23.967207,
      0.837445,
      0,
      0.860152,
      25.715445,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      9.891500,
      13,
      NULL,
      NULL,
      0.699339,
      NULL,
      3.711964,
      1,
      NULL,
      0,
      1.831441,
      3.382295,
      1,
      1,
      NULL,
      '11-25-1985',
      ' 6- 1-1995',
      NULL,
      '11-14-1991',
      ' 8-23-1997',
      ' 7-23-1986',
      NULL,
      NULL);
commit;
end;
/


