set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9623409';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '4',
      '3',
      '3',
      '1',
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '0',
      '0',
      '3',
      '0',
      '2',
      '4',
      '1',
      '3',
      NULL,
      '3',
      '0',
      NULL,
      '0',
      NULL,
      '1',
      '',
      '3',
      '4',
      NULL,
      '0',
      '4',
      NULL,
      '',
      NULL,
      '4',
      '2',
      '2',
      '0',
      '3',
      '0',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '20203223',
      NULL,
      NULL,
      '1413241',
      1,
      0.439351,
      3,
      1,
      '201042',
      1,
      ' 6-23-1976',
      NULL,
      NULL,
      24,
      40.332120,
      NULL,
      5,
      3.597954,
      102.914849,
      18,
      23,
      NULL,
      51,
      9,
      26,
      4,
      2,
      9,
      21.120136,
      16,
      82,
      NULL,
      58,
      2,
      120.538901,
      35,
      0,
      NULL,
      97.918330,
      NULL,
      76,
      252,
      159,
      '10-25-1990',
      16,
      NULL,
      5,
      15,
      62.253443,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      NULL,
      4,
      5.838338,
      NULL,
      ' 4- 4-1993',
      NULL,
      1.253783,
      212,
      0.892401,
      1.677352,
      NULL,
      1,
      0.035288,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      14.547796,
      98,
      13.772429,
      34.166392,
      74,
      36.387436,
      83,
      NULL,
      68.377919,
      NULL,
      74.921531,
      27,
      NULL,
      30.798884,
      36,
      6.419014,
      82.587100,
      125.729863,
      93,
      6.361490,
      ' 7- 6-1993',
      21.691852,
      2.109625,
      ' 7-15-1983',
      5.396271,
      NULL,
      NULL,
      NULL,
      13.659311,
      4,
      0,
      18.031214,
      1,
      53.303017,
      NULL,
      3,
      15.732734,
      19,
      1.778771,
      1.749984,
      1,
      1.389900,
      '11-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      101.242633,
      1,
      ' 1- 7-2003',
      NULL,
      NULL,
      NULL,
      27.530721,
      ' 7-29-1986',
      49.350485,
      ' 7-10-1980',
      21,
      NULL,
      NULL,
      49,
      NULL,
      ' 4- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      11,
      '11-21-1974',
      48,
      18,
      21.725551,
      NULL,
      NULL,
      9,
      ' 6-23-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


