set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1140',
      NULL,
      '13120444',
      '03301304',
      NULL,
      '11014301',
      '13414201',
      '40014214',
      NULL,
      '22214323',
      '02301042',
      '03240242',
      '11441414',
      '12430300',
      '44042210',
      '31014344',
      NULL,
      '24242004',
      '23423430',
      '22111304',
      '30421232',
      '03201432',
      '02240301',
      '44131330',
      '41314110',
      '30010203',
      NULL,
      '42401441',
      '20041232',
      '20340302',
      '11430124',
      '21001011',
      '42433241',
      NULL,
      '41000020',
      '40441421',
      NULL,
      '14310431',
      '13344302',
      '23040142',
      '32303120',
      '13034211',
      NULL,
      NULL,
      '30032301',
      '212',
      '03',
      NULL,
      9,
      '2200404',
      NULL,
      1.872351,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      61.530111,
      NULL,
      18.776126,
      NULL,
      10,
      NULL,
      23,
      3.740300,
      31.672585,
      NULL,
      28.444540,
      17.747808,
      41,
      8.570806,
      29,
      7.773155,
      6,
      11.461871,
      23.574459,
      1.892213,
      NULL,
      7.232678,
      0,
      11.438103,
      0.501398,
      79,
      66,
      6.824823,
      138,
      NULL,
      3,
      ' 1-13-1997',
      20.842164,
      47.383588,
      3,
      22,
      122.080559,
      212.377489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      3,
      NULL,
      3,
      2.219500,
      4,
      ' 7- 6-1997',
      0,
      1.185191,
      175,
      3.963945,
      1.393328,
      76.488541,
      0,
      1,
      42,
      NULL,
      NULL,
      NULL,
      ' 3-29-1978',
      33,
      0.588840,
      21,
      102,
      NULL,
      17,
      NULL,
      81,
      NULL,
      32,
      NULL,
      38.267740,
      ' 2- 7-1974',
      4,
      1.881968,
      NULL,
      NULL,
      8,
      NULL,
      2,
      ' 7-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102.118473,
      1.942370,
      ' 4-25-1995',
      NULL,
      NULL,
      NULL,
      37.370831,
      '10-28-1986',
      34,
      ' 6-25-1993',
      NULL,
      7.606617,
      '11- 2-1993',
      153.091992,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 2- 3-1977',
      32,
      6,
      9.740553,
      ' 5-20-2000',
      1,
      133.857242,
      ' 3- 6-1986',
      6,
      26.702928,
      7.803569,
      11.070484,
      '11- 7-1995',
      40.247954,
      1,
      125,
      '10-23-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


