set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0224',
      '20142223',
      NULL,
      NULL,
      '32210202',
      NULL,
      '22322021',
      '23332222',
      NULL,
      '22343002',
      '12443444',
      '11423333',
      '42340041',
      '21210204',
      '11440424',
      '12224013',
      '04320012',
      '43112122',
      '34323001',
      '21140402',
      '00203443',
      '33401143',
      '43240134',
      NULL,
      '12010114',
      '21104301',
      '04423340',
      '20141410',
      '43434133',
      '30431210',
      '30011012',
      NULL,
      NULL,
      '31233224',
      '40424402',
      '34134131',
      '01431404',
      '34113430',
      '40210424',
      '10212443',
      '32343222',
      '21042411',
      '32202043',
      NULL,
      '23220423',
      '234',
      '10',
      10,
      11.853197,
      '4114303',
      3,
      15.794023,
      2,
      NULL,
      '113243',
      0.219766,
      ' 4- 4-1990',
      ' 0-21-1992',
      NULL,
      122.960114,
      24,
      5.117665,
      4,
      13.973904,
      42,
      1.425566,
      17.118612,
      5,
      NULL,
      20.232427,
      46.686731,
      20.602811,
      5,
      NULL,
      2,
      10.993693,
      50.732503,
      21,
      11,
      13.288675,
      10,
      9.888408,
      1,
      127,
      207.177912,
      30,
      95,
      63.295722,
      82.014151,
      ' 8-25-1993',
      51,
      35.852835,
      NULL,
      13.999469,
      NULL,
      NULL,
      ' 7-18-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79.176391,
      28.665648,
      0,
      4.122073,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      0.975240,
      NULL,
      0.150318,
      1,
      17.804197,
      NULL,
      NULL,
      NULL,
      ' 8-11-1976',
      NULL,
      NULL,
      76.427889,
      52,
      22,
      67.712380,
      21.378139,
      34,
      38,
      NULL,
      NULL,
      55.501357,
      NULL,
      12.065488,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      3.742081,
      '11-23-1989',
      19.398872,
      6.462468,
      ' 9-28-1988',
      10.009257,
      6.960479,
      12.759949,
      10.267053,
      11.912507,
      19,
      0.195777,
      NULL,
      NULL,
      37,
      0,
      1.538180,
      3,
      15.002886,
      NULL,
      0,
      1,
      0.046385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      133.350892,
      NULL,
      ' 3-15-1974',
      NULL,
      NULL,
      NULL,
      53,
      ' 2- 2-2002',
      23.551334,
      ' 4- 1-1988',
      13,
      NULL,
      ' 3-10-1991',
      138,
      75.488353,
      ' 9-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      56.917736,
      37.256907,
      47,
      ' 9- 9-1989',
      NULL,
      6,
      NULL,
      14.221145,
      25,
      17.162794,
      15,
      '10-12-2000',
      20,
      0.597572,
      74.893445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


