set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9907503';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '0',
      '3',
      '3',
      '0',
      '4',
      NULL,
      '4',
      NULL,
      '1',
      '4',
      '2',
      '2',
      '2',
      NULL,
      '1',
      '2',
      '2',
      NULL,
      NULL,
      '2',
      '2',
      '4',
      '',
      NULL,
      '',
      '2',
      '4',
      NULL,
      '1',
      '1',
      '',
      '',
      '3',
      '2',
      NULL,
      '3',
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '2',
      '0',
      '243',
      NULL,
      NULL,
      45,
      '3240041',
      NULL,
      0,
      1,
      1,
      '404231',
      0.214421,
      ' 0- 5-1980',
      ' 5- 6-1975',
      NULL,
      42.846545,
      3.567864,
      5.365807,
      14,
      NULL,
      13,
      6,
      9,
      7.582312,
      2,
      13,
      25.115422,
      11,
      30,
      3,
      NULL,
      9,
      48.165241,
      14.870894,
      13.479653,
      3,
      33,
      1.709898,
      0.877898,
      61.915274,
      132.285822,
      NULL,
      3,
      89,
      34.229804,
      '10- 5-1994',
      NULL,
      NULL,
      NULL,
      25.777028,
      21.744803,
      161.296583,
      ' 3-26-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.465091,
      NULL,
      26.668319,
      NULL,
      29.596949,
      0,
      '11-19-1989',
      1,
      1,
      101.548504,
      NULL,
      0.497963,
      168,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 8-1988',
      81.526031,
      4,
      103,
      NULL,
      NULL,
      76,
      23,
      19.315412,
      89,
      38.919468,
      78.866128,
      72,
      ' 0-17-1975',
      30.605961,
      15,
      24.904231,
      27,
      97.489135,
      NULL,
      13,
      ' 3- 0-1985',
      12,
      2,
      '11-11-1988',
      10.158501,
      14,
      4,
      18.829981,
      7.118224,
      6.285702,
      1,
      3,
      0,
      NULL,
      2,
      NULL,
      2.575263,
      17,
      3.564663,
      NULL,
      0,
      0,
      ' 5-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      123.990491,
      NULL,
      '10-18-1981',
      NULL,
      NULL,
      NULL,
      16,
      ' 9- 1-1982',
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      10,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      25.428691,
      NULL,
      61.917285,
      17.403504,
      4.105571,
      ' 7- 7-1975',
      NULL,
      92.852668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


