set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9755023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '3',
      '2',
      '3',
      '3',
      '1',
      NULL,
      '0',
      '4',
      NULL,
      '0',
      '0',
      '3',
      '0',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '1',
      '4',
      '4',
      '2',
      '',
      '2',
      '',
      '4',
      '0',
      '2',
      '1',
      '1',
      NULL,
      '',
      '3',
      '0',
      '2',
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0',
      '4',
      '1',
      '343',
      '03',
      47,
      NULL,
      '1111014',
      2,
      NULL,
      0,
      NULL,
      '441114',
      1.778276,
      ' 3-26-2001',
      NULL,
      12,
      163,
      9,
      0.209795,
      NULL,
      21,
      56,
      0.172649,
      1.004201,
      11.191938,
      16,
      11,
      18.390793,
      3.180888,
      1.819663,
      7,
      NULL,
      NULL,
      65,
      2,
      60.364987,
      1,
      93,
      NULL,
      NULL,
      64,
      NULL,
      11.760176,
      22.847456,
      57.165422,
      14,
      ' 2- 7-2000',
      13,
      23,
      12,
      0.887124,
      44.571125,
      101,
      ' 9- 6-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3,
      22.123429,
      8.955974,
      1,
      ' 9-22-1999',
      0.243081,
      1,
      36.310873,
      1.477553,
      2.255806,
      46,
      0.020514,
      4,
      27,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1974',
      NULL,
      41,
      0.906610,
      67.333950,
      5,
      25.544623,
      64.006810,
      69,
      40,
      56.706472,
      12.154501,
      50.870011,
      ' 4- 3-1985',
      17,
      8.513394,
      NULL,
      25.333011,
      NULL,
      NULL,
      7.496410,
      '10- 6-1994',
      0,
      6.243359,
      ' 8- 7-1988',
      NULL,
      15,
      NULL,
      4.016692,
      7.449104,
      NULL,
      NULL,
      NULL,
      NULL,
      45.303152,
      3,
      0,
      13,
      5.621588,
      1.607261,
      0.249886,
      1.890502,
      NULL,
      ' 7- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      61.734684,
      3.637871,
      '10- 8-2000',
      NULL,
      NULL,
      NULL,
      49,
      ' 3- 8-2003',
      NULL,
      '11-16-1979',
      8.427956,
      9,
      ' 9-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.822945,
      ' 8-20-1992',
      38.503290,
      6,
      51.736971,
      NULL,
      1,
      42,
      ' 2-15-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


