set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9755023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '4',
      NULL,
      '2',
      NULL,
      NULL,
      '0',
      '2',
      '3',
      NULL,
      '1',
      '1',
      NULL,
      '2',
      '2',
      '2',
      '0',
      NULL,
      '1',
      '3',
      NULL,
      '1',
      '0',
      '',
      NULL,
      '',
      '4',
      '2',
      '0',
      '3',
      '1',
      '',
      '',
      '2',
      '3',
      NULL,
      '2',
      '3',
      '2',
      '4',
      '3',
      '2',
      '1',
      '0',
      '003',
      '00133430',
      NULL,
      47,
      '4243231',
      NULL,
      0,
      0,
      NULL,
      '242204',
      2,
      ' 7- 4-1994',
      ' 8-25-2000',
      31,
      241,
      17,
      15,
      NULL,
      3,
      NULL,
      2.916743,
      1.342335,
      8,
      0.399016,
      6.395236,
      28.271203,
      NULL,
      5,
      NULL,
      35,
      26.003071,
      61,
      23,
      41,
      7,
      32.692341,
      16,
      1.510662,
      26,
      183,
      61,
      NULL,
      215,
      91.990849,
      ' 1-16-1998',
      38.195171,
      67.649852,
      6.123210,
      29.771155,
      166,
      76.994021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.786005,
      10.409909,
      16.887060,
      8.895704,
      NULL,
      ' 2-27-1983',
      0.902489,
      1.862967,
      200,
      0.543956,
      NULL,
      2,
      1.191918,
      2.889495,
      58.018629,
      NULL,
      NULL,
      NULL,
      ' 2- 1-2001',
      103,
      44,
      33,
      25.423511,
      95,
      105.076898,
      50.764775,
      62,
      102,
      75.892458,
      27.502741,
      37.073710,
      ' 3-26-1994',
      17,
      12,
      19,
      NULL,
      68.346435,
      NULL,
      1.336727,
      ' 4-17-1983',
      0,
      1,
      ' 4-11-1990',
      3.023540,
      3,
      14,
      NULL,
      24,
      20,
      0.059804,
      NULL,
      0,
      32.656350,
      0.975562,
      NULL,
      10.124776,
      NULL,
      1.485220,
      NULL,
      NULL,
      NULL,
      ' 9-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      238.719010,
      1,
      ' 0-10-1990',
      NULL,
      NULL,
      NULL,
      52,
      ' 1- 5-2001',
      2,
      ' 1-19-1993',
      NULL,
      17.449074,
      ' 4-15-1987',
      94.150055,
      29.140361,
      ' 6-24-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      45,
      27.387890,
      18.294336,
      ' 1- 2-1982',
      0.517166,
      NULL,
      ' 3- 1-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


