set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0420',
      NULL,
      NULL,
      NULL,
      '43424004',
      NULL,
      '20203213',
      NULL,
      '11314140',
      '31222430',
      '23124041',
      '43401430',
      '23113200',
      NULL,
      '22302241',
      '01013003',
      NULL,
      '41323224',
      NULL,
      NULL,
      '13124343',
      '00323001',
      '31132432',
      NULL,
      '04411143',
      '12412240',
      '41043224',
      '04021333',
      NULL,
      '13413413',
      '01310444',
      NULL,
      '04220221',
      NULL,
      '04223413',
      '14441343',
      '11212442',
      '34002414',
      '40321033',
      NULL,
      NULL,
      '32401302',
      '44230244',
      '32124410',
      '03232310',
      NULL,
      '32',
      NULL,
      NULL,
      '4242303',
      3,
      0.051027,
      NULL,
      NULL,
      '113343',
      4,
      ' 2-15-2001',
      ' 3- 3-1989',
      15,
      NULL,
      1.965862,
      4.663295,
      5.272800,
      NULL,
      NULL,
      NULL,
      12,
      0.271757,
      7.451477,
      12.239478,
      6.147534,
      NULL,
      20,
      0,
      NULL,
      2.226790,
      27.218398,
      0.920836,
      4.252121,
      7,
      32,
      1.857331,
      NULL,
      NULL,
      159,
      32,
      108.663807,
      54.171723,
      131.167976,
      NULL,
      40,
      32.069076,
      9.356836,
      27,
      123,
      146,
      NULL,
      NULL,
      23,
      5.133263,
      4,
      7,
      11,
      1.858070,
      2.350238,
      0.551272,
      NULL,
      11.537032,
      0,
      0.787212,
      4,
      1,
      1,
      1.178032,
      NULL,
      NULL,
      3.731634,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-22-1995',
      34,
      62.503770,
      7,
      34.246626,
      14.973126,
      3.476809,
      NULL,
      NULL,
      1.502520,
      52.332147,
      0.076521,
      0.001565,
      NULL,
      0.251070,
      2.026409,
      26,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1987',
      NULL,
      14,
      57,
      60.826493,
      25.981919,
      NULL,
      64.492896,
      25,
      38,
      22.108067,
      NULL,
      47,
      NULL,
      NULL,
      2,
      3.796530,
      31,
      31.729306,
      23,
      NULL,
      ' 8-15-2002',
      5,
      7,
      ' 7-22-1993',
      4,
      0.739933,
      17.069648,
      1,
      NULL,
      8,
      5,
      4.425642,
      1,
      89,
      4.260416,
      17.014071,
      5.464437,
      2,
      NULL,
      5,
      NULL,
      NULL,
      ' 2- 8-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      76.973055,
      7,
      ' 4- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-25-1987',
      NULL,
      '10-11-1984',
      1,
      3.232728,
      ' 1-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 3-18-1993',
      5.163257,
      25.809778,
      8.164545,
      ' 0-28-1974',
      NULL,
      164.736529,
      '11- 4-1976',
      10.978226,
      47.047160,
      20.395546,
      80,
      NULL,
      NULL,
      0.777431,
      NULL,
      ' 4-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


