set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4442',
      '04432400',
      NULL,
      '10022004',
      '10200213',
      '41444240',
      '10314401',
      '03113342',
      NULL,
      '03120111',
      '14342120',
      '24142313',
      NULL,
      '00131443',
      '02322104',
      NULL,
      '10444332',
      NULL,
      '04334010',
      '33201034',
      '41410302',
      '01014131',
      '14242423',
      '42140420',
      '33214214',
      '04430032',
      '13001432',
      '13220213',
      '40223023',
      '23240443',
      '02142321',
      '02142231',
      '11211134',
      '40244102',
      '22300023',
      '40344021',
      '22022240',
      '42433103',
      '44422433',
      '32133142',
      NULL,
      '33004230',
      '10110022',
      '02431434',
      NULL,
      '203',
      '23',
      36.193550,
      23.007195,
      '2423344',
      3.227388,
      42,
      0,
      NULL,
      '322301',
      4.642271,
      ' 4-19-2003',
      NULL,
      119,
      24,
      18.270132,
      4.268859,
      NULL,
      NULL,
      23.054104,
      NULL,
      3.382829,
      3.982621,
      6,
      4,
      0,
      NULL,
      13.452143,
      10,
      6,
      4.921910,
      17.561587,
      0,
      32,
      NULL,
      25.805477,
      NULL,
      0,
      40,
      91.583508,
      9,
      29,
      5.443069,
      91.285200,
      '10-19-2003',
      35.764044,
      36,
      14,
      17.449161,
      177,
      132,
      ' 1-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      4.450116,
      NULL,
      8,
      7,
      NULL,
      NULL,
      NULL,
      3,
      168,
      1,
      1.709737,
      62,
      3.213844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-13-1975',
      34,
      36.693431,
      NULL,
      NULL,
      45.619412,
      NULL,
      34,
      NULL,
      78,
      9.671369,
      56,
      23.235166,
      ' 6-13-1990',
      14.718489,
      NULL,
      1.670145,
      29,
      61,
      51,
      10,
      ' 2- 3-1998',
      12.176961,
      2.933145,
      NULL,
      NULL,
      10,
      NULL,
      1,
      2.648489,
      NULL,
      0.251384,
      NULL,
      0,
      87.991977,
      1.883704,
      7,
      5,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-18-1981',
      NULL,
      NULL,
      NULL,
      39.776981,
      ' 8- 1-1975',
      13,
      ' 9-22-2001',
      0,
      NULL,
      '11- 8-1990',
      76,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      ' 5-18-2002',
      NULL,
      20.906133,
      7.437209,
      ' 3-20-1986',
      0.085612,
      NULL,
      ' 8-15-1974',
      NULL,
      47,
      13.939896,
      43.247571,
      ' 8-16-1984',
      15.312287,
      NULL,
      128.452852,
      ' 7- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


