set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9634811';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '0',
      '4',
      '2',
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      '0',
      '4',
      '4',
      '0',
      '4',
      '3',
      NULL,
      NULL,
      '1',
      NULL,
      '4',
      NULL,
      '3',
      '1',
      '',
      NULL,
      '',
      '3',
      NULL,
      '0',
      '2',
      '4',
      '',
      NULL,
      NULL,
      '4',
      '2',
      '3',
      '2',
      NULL,
      '3',
      '3',
      '0',
      '4',
      '2',
      '104',
      '34410210',
      34.775121,
      54,
      NULL,
      3.092538,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      ' 1- 3-1982',
      ' 8-26-2001',
      NULL,
      35,
      34.206630,
      4.920951,
      26.842006,
      16,
      50.832035,
      10,
      NULL,
      20,
      28,
      19.434639,
      23.102005,
      17.013423,
      33,
      19,
      NULL,
      NULL,
      23,
      13,
      NULL,
      6.938601,
      71,
      8.378296,
      NULL,
      NULL,
      183.424471,
      24.328653,
      152.631009,
      248,
      72,
      ' 4-26-1989',
      36,
      20,
      23.009375,
      16,
      106.271308,
      162,
      '11-23-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      34.271296,
      9.623278,
      13.149693,
      4.812666,
      5.475798,
      NULL,
      1.354387,
      0,
      141.978119,
      NULL,
      1,
      101.287023,
      0,
      1.683815,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-29-2003',
      2.661672,
      1,
      63.325408,
      28,
      38.966734,
      64,
      63,
      NULL,
      86,
      90,
      67,
      60.790122,
      '11-22-1996',
      18,
      9.695191,
      21.574635,
      10.498605,
      47.346549,
      122.745505,
      4.149965,
      ' 1- 6-2000',
      26.890352,
      9.649230,
      NULL,
      2.437940,
      9,
      3,
      19.509006,
      2.625059,
      NULL,
      0.596719,
      8,
      1,
      NULL,
      3.971996,
      1,
      7,
      1,
      5.414478,
      1,
      NULL,
      1.574602,
      ' 2-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      33,
      ' 9-13-1994',
      NULL,
      NULL,
      NULL,
      9,
      ' 7- 8-1993',
      NULL,
      ' 5-13-1980',
      9,
      5,
      ' 0-18-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      15.338421,
      '11- 4-2002',
      69,
      NULL,
      18,
      ' 0-25-2000',
      3,
      160.987116,
      ' 1-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


