set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3402',
      '14221310',
      '01224201',
      '10103224',
      '00132004',
      '02412100',
      '21103031',
      '11332424',
      '40342014',
      '40342042',
      '34244440',
      NULL,
      NULL,
      '43311233',
      '13111013',
      '30222134',
      '13312002',
      '32404101',
      '02424044',
      '43304244',
      '04340330',
      '01323430',
      '43021324',
      '13022114',
      NULL,
      '30034103',
      '42214402',
      '41434424',
      '14320420',
      '32344013',
      '13201233',
      '01204311',
      NULL,
      NULL,
      NULL,
      '22412243',
      '43441342',
      '30434142',
      '21131441',
      NULL,
      '33020210',
      NULL,
      '14313102',
      '04102134',
      '33421324',
      '',
      '',
      NULL,
      NULL,
      '2243341',
      2.754564,
      1.245969,
      1,
      NULL,
      NULL,
      0.725143,
      NULL,
      ' 2-13-1988',
      52,
      NULL,
      NULL,
      2.031174,
      28,
      0.094111,
      7,
      8,
      15.919460,
      14.766207,
      NULL,
      1.153351,
      8,
      7,
      7.346488,
      7,
      2,
      3,
      12,
      6,
      NULL,
      15,
      51,
      5,
      NULL,
      NULL,
      159,
      NULL,
      NULL,
      151.303254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8.784634,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.138762,
      0.274653,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      90,
      14.848363,
      94,
      23,
      10.443922,
      50.322490,
      16,
      35.733279,
      NULL,
      66,
      NULL,
      NULL,
      29,
      18.440806,
      63.807996,
      35.313072,
      82.563404,
      5,
      ' 6-18-1986',
      8.855475,
      NULL,
      ' 8-15-2003',
      11.176980,
      8.230070,
      14.710475,
      1,
      2,
      2.996365,
      NULL,
      17,
      NULL,
      89,
      0,
      9.882283,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      14.860588,
      ' 7-21-2001',
      NULL,
      0,
      ' 0-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.137921,
      56,
      NULL,
      NULL,
      3,
      29,
      NULL,
      5,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      6.970531,
      NULL,
      0,
      1,
      0,
      NULL,
      ' 0-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1999',
      NULL);
commit;
end;
/


