set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1234',
      NULL,
      NULL,
      '20040040',
      '03333012',
      NULL,
      '24234100',
      '00121020',
      '23112310',
      '24040303',
      '41214114',
      '34332404',
      '13213421',
      '30332303',
      '03311312',
      '30000312',
      '23110214',
      '10111113',
      NULL,
      NULL,
      '44212411',
      '42432144',
      '03320000',
      '01121033',
      '23034440',
      '22442041',
      NULL,
      '00033430',
      '20244020',
      '44213424',
      '20433310',
      '10011234',
      '02403120',
      '42402113',
      '13000111',
      NULL,
      '32033131',
      '00240214',
      '24131020',
      '44102211',
      '44400022',
      '31342314',
      '10331310',
      '34302144',
      NULL,
      '400',
      NULL,
      NULL,
      NULL,
      '0022330',
      2.007383,
      23,
      0,
      NULL,
      '131230',
      5.904702,
      NULL,
      '11- 6-1983',
      1.052780,
      NULL,
      11,
      2,
      2,
      1,
      NULL,
      5.645171,
      7,
      5,
      13.912128,
      4,
      13.201715,
      9.941130,
      12.900716,
      NULL,
      6,
      NULL,
      NULL,
      11,
      47.532544,
      12.734876,
      8.496203,
      1,
      1.267131,
      NULL,
      36.109831,
      12.939943,
      55,
      109.557584,
      NULL,
      ' 6-25-2003',
      4.304198,
      30,
      25.396365,
      3,
      100,
      163,
      '11-15-1995',
      8,
      0.332243,
      NULL,
      NULL,
      4,
      2.898174,
      3,
      2,
      0.792873,
      1,
      1.825286,
      NULL,
      1.183073,
      0.411365,
      0.995413,
      0.403990,
      1.380205,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1994',
      16,
      NULL,
      4,
      NULL,
      13.026346,
      5,
      ' 4-26-1998',
      0,
      1,
      NULL,
      0,
      0,
      32.660598,
      0.460129,
      2,
      1,
      NULL,
      NULL,
      NULL,
      ' 4-27-1991',
      53.843999,
      58,
      62.716690,
      3.157542,
      44,
      83,
      31,
      28,
      29.077817,
      58.813128,
      NULL,
      NULL,
      ' 6-15-1982',
      18,
      NULL,
      3.153545,
      NULL,
      61,
      30,
      6,
      ' 3- 6-1991',
      14,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      12.293890,
      8.610067,
      0,
      1,
      0.063818,
      50,
      7,
      5,
      2,
      3.188286,
      3.855641,
      1,
      4,
      0.881941,
      '10- 1-1982',
      NULL,
      3.668114,
      1,
      NULL,
      28.763236,
      6,
      ' 4-17-1986',
      NULL,
      NULL,
      NULL,
      25.699068,
      NULL,
      38.043695,
      ' 8-23-1993',
      NULL,
      4,
      ' 4-16-2000',
      138,
      54.997770,
      '11-25-1987',
      NULL,
      28.319100,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      8.243226,
      ' 2-23-1981',
      47,
      14.336480,
      46.807679,
      ' 3-12-1978',
      NULL,
      147,
      ' 9- 1-1997',
      9,
      NULL,
      2,
      14.543053,
      '10- 9-1998',
      61.672082,
      1.215867,
      21,
      ' 9- 4-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


