set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43021030',
      '20143321',
      '42224123',
      '44014320',
      '24204023',
      '13203224',
      '30101021',
      '21302130',
      '00110444',
      NULL,
      '42212241',
      '24432020',
      '11003330',
      NULL,
      '10432332',
      '13242412',
      '30134334',
      '32142024',
      '32022121',
      NULL,
      NULL,
      '31222224',
      '31442213',
      '04020423',
      '33212212',
      '20202043',
      '31443440',
      '14144121',
      '43010343',
      '22030111',
      '10000402',
      '41043321',
      NULL,
      '44004144',
      '04340240',
      NULL,
      NULL,
      '12004322',
      NULL,
      '23244120',
      NULL,
      NULL,
      '03140012',
      NULL,
      '131',
      '12',
      NULL,
      5.275745,
      '1010442',
      NULL,
      55,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-17-1986',
      ' 7-27-2003',
      NULL,
      NULL,
      1,
      11,
      22,
      7.110915,
      20,
      8,
      17,
      9,
      24.367324,
      NULL,
      15,
      8.388784,
      27,
      1.870727,
      NULL,
      0,
      34.466831,
      12,
      32,
      16.135060,
      49.111488,
      NULL,
      1,
      14,
      NULL,
      49.738885,
      130,
      14,
      152,
      '10- 3-1996',
      8,
      8.833881,
      27,
      28,
      104.276577,
      81,
      ' 8-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.349896,
      4.724847,
      19,
      5.603369,
      11.526097,
      11.688735,
      ' 7- 0-1989',
      0.661085,
      1.506402,
      NULL,
      1,
      NULL,
      60,
      NULL,
      NULL,
      57.049127,
      NULL,
      NULL,
      NULL,
      '11-17-1982',
      NULL,
      NULL,
      76.564920,
      17.457713,
      28.026513,
      59.806389,
      18,
      58,
      91,
      79,
      89.749437,
      12.320994,
      ' 4-19-1977',
      5.242965,
      NULL,
      17.008006,
      49,
      13,
      48,
      8,
      ' 2- 5-1981',
      11,
      13.913440,
      ' 0-17-1977',
      7,
      3.864689,
      NULL,
      9.021001,
      13,
      3.972937,
      0.798673,
      12,
      1,
      NULL,
      5.635587,
      NULL,
      2,
      20,
      NULL,
      1,
      4.965954,
      NULL,
      '11- 8-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.239323,
      '11- 4-1985',
      NULL,
      NULL,
      NULL,
      34,
      ' 4-20-1983',
      19.604212,
      NULL,
      3.205622,
      10,
      '11-10-1981',
      83.279942,
      85.112488,
      '10- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10,
      ' 4-11-2000',
      NULL,
      60.286064,
      4.455101,
      ' 8-27-1989',
      0,
      147,
      ' 5- 9-1989',
      NULL,
      NULL,
      16,
      37.939877,
      ' 2-22-1990',
      57,
      NULL,
      118.370622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


