set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '0',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      '0',
      '1',
      '3',
      '3',
      '0',
      '3',
      NULL,
      '2',
      '2',
      '0',
      '3',
      '3',
      '4',
      '3',
      NULL,
      '0',
      '',
      NULL,
      '4',
      '2',
      '0',
      '3',
      '',
      '',
      '1',
      '1',
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '0',
      NULL,
      '3',
      '1',
      NULL,
      '42213443',
      27,
      NULL,
      '0032114',
      1,
      NULL,
      2,
      NULL,
      '411223',
      3.464377,
      ' 6- 9-1984',
      ' 8-17-1982',
      53,
      NULL,
      13.412690,
      10.256482,
      4.776170,
      7,
      26,
      NULL,
      19.667646,
      4,
      16,
      3.467418,
      1,
      12.341456,
      13.271137,
      NULL,
      NULL,
      2.702228,
      19,
      11,
      14,
      6,
      43,
      4.299445,
      1,
      12.038692,
      143,
      33,
      143.569508,
      NULL,
      36.127016,
      '10-16-1996',
      7.194089,
      NULL,
      24.808998,
      7,
      NULL,
      176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      7,
      NULL,
      38.888600,
      0.282474,
      ' 4-20-1980',
      1.512091,
      1,
      NULL,
      1,
      0,
      77.230809,
      0.118715,
      0.389242,
      43.758912,
      NULL,
      NULL,
      NULL,
      '11-16-1996',
      7,
      NULL,
      7.786233,
      NULL,
      29,
      NULL,
      19.301517,
      39,
      28,
      9.447935,
      NULL,
      12.907542,
      NULL,
      NULL,
      14,
      12,
      52.753278,
      7.273156,
      48,
      6,
      ' 8-28-1975',
      NULL,
      3,
      ' 2-10-1994',
      13.625438,
      10,
      2,
      13,
      4,
      0,
      0.378947,
      13,
      0.916786,
      NULL,
      3,
      1,
      12.441322,
      28.679812,
      NULL,
      5,
      1,
      0,
      ' 3-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 5-18-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-13-1978',
      19.066811,
      NULL,
      NULL,
      14,
      ' 7-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5.442744,
      ' 2-13-1980',
      32,
      28.378729,
      46.000045,
      ' 1- 1-1982',
      0,
      NULL,
      ' 6-19-1999',
      1,
      26.924693,
      NULL,
      41.277638,
      NULL,
      36,
      0.543289,
      NULL,
      ' 4- 4-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


