set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131002';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      '4',
      '1',
      NULL,
      '0',
      '0',
      '0',
      '0',
      '1',
      '0',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      NULL,
      '1',
      '3',
      NULL,
      '4',
      '3',
      '3',
      '',
      '4',
      '',
      NULL,
      '4',
      '3',
      '0',
      '4',
      NULL,
      '',
      NULL,
      '1',
      NULL,
      '0',
      '1',
      '2',
      '3',
      '1',
      NULL,
      '1',
      '3',
      '434',
      '24341131',
      52.954174,
      NULL,
      '2311231',
      NULL,
      225.258638,
      3,
      1,
      '002132',
      NULL,
      ' 9-12-1998',
      ' 4-10-1989',
      83.802705,
      9,
      8.007928,
      11,
      9,
      19.190203,
      14.741841,
      5.316588,
      23,
      16,
      18,
      4,
      2,
      13.464617,
      3,
      2,
      9.152003,
      9,
      27,
      0,
      24,
      NULL,
      50.660545,
      8.969908,
      0,
      47.335609,
      57,
      65,
      59,
      NULL,
      153.039868,
      ' 6-21-1981',
      14,
      NULL,
      25,
      3,
      133,
      101,
      ' 0-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      22.812383,
      10.843422,
      16,
      6.872611,
      ' 0-24-1983',
      0,
      0,
      94,
      NULL,
      0,
      111.123847,
      NULL,
      1,
      49.095705,
      NULL,
      NULL,
      NULL,
      ' 8-29-1994',
      21.089334,
      63,
      NULL,
      73.815450,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      42.205024,
      16.113248,
      20.328012,
      ' 2- 3-1988',
      14.931698,
      12,
      16.194076,
      18.763176,
      1.421176,
      24,
      10,
      ' 0-15-2000',
      2,
      15.878448,
      ' 9-23-1985',
      4,
      14.734725,
      NULL,
      6,
      3,
      7,
      1,
      9,
      0.925895,
      NULL,
      0,
      0,
      9,
      19.194084,
      0.327213,
      2,
      0,
      0.227905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      13,
      ' 8- 6-1999',
      NULL,
      NULL,
      NULL,
      36,
      '11- 5-1976',
      30,
      ' 4- 7-1994',
      0.970789,
      16.443053,
      ' 3-23-2000',
      79,
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      32,
      12,
      5.310471,
      ' 4- 8-1976',
      NULL,
      132.073366,
      ' 3-12-1983',
      17,
      NULL,
      3,
      NULL,
      '11- 9-1995',
      32.746519,
      0.899634,
      237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


