set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9308721';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0433',
      '20120341',
      '03210032',
      '14014433',
      '41141201',
      NULL,
      '24313434',
      '12144030',
      NULL,
      '02420111',
      '41013220',
      NULL,
      '12003214',
      '31030143',
      '10130104',
      NULL,
      '30312402',
      '23030132',
      '11132313',
      '01211022',
      '11243000',
      '03124430',
      '24111231',
      NULL,
      '21314233',
      NULL,
      '00430021',
      '32334340',
      '20224220',
      '12400104',
      '01123204',
      NULL,
      '41032123',
      '22334300',
      '14202120',
      NULL,
      '04140000',
      NULL,
      '30430342',
      '34014302',
      '02202032',
      NULL,
      NULL,
      '33331122',
      '30131433',
      '041',
      NULL,
      NULL,
      NULL,
      '2103100',
      1,
      0,
      0,
      NULL,
      '040423',
      NULL,
      ' 6- 6-1989',
      ' 0-24-1998',
      NULL,
      NULL,
      32,
      11.173966,
      9,
      14.427518,
      114,
      17,
      NULL,
      NULL,
      7.176493,
      NULL,
      20.821854,
      11,
      15,
      5.838072,
      20,
      0.489938,
      32,
      5.536206,
      31,
      18.674396,
      19.674697,
      3.587253,
      0,
      102.358434,
      154.540350,
      20,
      6.074936,
      53,
      1.546893,
      NULL,
      32.661763,
      24,
      12.196574,
      22.067434,
      NULL,
      157.114205,
      '10- 7-1979',
      NULL,
      NULL,
      NULL,
      1.213282,
      NULL,
      0.228673,
      2.816287,
      0.394325,
      NULL,
      1,
      1,
      1,
      0.249027,
      2.606656,
      1.193525,
      NULL,
      0.880721,
      1,
      1,
      1.273822,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 6-2000',
      37,
      22.873243,
      37,
      NULL,
      13,
      0,
      ' 0-15-1984',
      1,
      0,
      239,
      1,
      1,
      NULL,
      NULL,
      0.855398,
      62.808649,
      NULL,
      1.182840,
      135,
      ' 0-28-2000',
      10,
      28,
      84,
      21.333279,
      0,
      39,
      NULL,
      NULL,
      0.386045,
      0,
      51,
      64.140601,
      NULL,
      NULL,
      NULL,
      41.712745,
      31.060093,
      8,
      134,
      NULL,
      ' 0-21-1985',
      NULL,
      19.091412,
      NULL,
      7.440686,
      NULL,
      21.915157,
      15.935627,
      9.215546,
      NULL,
      0.258693,
      10.986893,
      0,
      137,
      0.514807,
      1.537422,
      25.640225,
      2,
      NULL,
      NULL,
      3,
      NULL,
      ' 9- 1-1980',
      2,
      NULL,
      1.775165,
      ' 0-16-1997',
      38,
      57,
      ' 3-13-1979',
      20.852410,
      1,
      '10-19-1980',
      29,
      ' 3-12-1996',
      NULL,
      ' 0-23-1990',
      16.235441,
      NULL,
      ' 9- 8-2000',
      17,
      97,
      ' 6- 6-1978',
      0.460979,
      5.998416,
      ' 4-22-1998',
      0.272546,
      NULL,
      NULL,
      2,
      2,
      13.646409,
      ' 6- 7-2000',
      49.435294,
      NULL,
      16.794279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.600848);
commit;
end;
/


