set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006663';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1002',
      '13300242',
      '22402141',
      '21341240',
      NULL,
      '20332032',
      '31423123',
      '00320014',
      '13343130',
      NULL,
      NULL,
      '02143343',
      NULL,
      '20320340',
      '40112124',
      NULL,
      '31332421',
      NULL,
      NULL,
      NULL,
      '33101124',
      '11114000',
      '01420200',
      NULL,
      NULL,
      '41102211',
      NULL,
      '33302243',
      '34322434',
      '41141124',
      '21114234',
      '34133111',
      '44241130',
      '23300040',
      NULL,
      '02031023',
      '33403112',
      '12224121',
      '43224222',
      NULL,
      '02214140',
      '11123313',
      '03103000',
      '42301200',
      '14040213',
      '121',
      '33',
      NULL,
      NULL,
      '0044043',
      0.606842,
      0.755506,
      2,
      NULL,
      '143244',
      4,
      NULL,
      ' 2-26-1981',
      13,
      NULL,
      14.510012,
      17.997330,
      16,
      13.852738,
      26.718348,
      16,
      37,
      23.079759,
      55,
      27,
      30.086898,
      4,
      33,
      6.663093,
      3.688840,
      16.393083,
      NULL,
      1,
      67,
      NULL,
      99,
      6,
      1.622759,
      163.040467,
      NULL,
      NULL,
      4,
      72,
      252.144785,
      NULL,
      58.154868,
      45.695141,
      35.315856,
      NULL,
      NULL,
      194.145341,
      NULL,
      NULL,
      1,
      1.433746,
      1,
      NULL,
      0.516205,
      3,
      0.885957,
      0.591303,
      0.836159,
      0,
      0.855490,
      0.597916,
      1.470189,
      NULL,
      1,
      0.003000,
      0.391249,
      0,
      1.832122,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-19-1991',
      11,
      NULL,
      NULL,
      6.479058,
      NULL,
      2,
      ' 6-29-1992',
      1,
      0,
      79,
      0.068911,
      0.451284,
      NULL,
      0.186778,
      0,
      55,
      0,
      1,
      NULL,
      ' 4- 2-2002',
      NULL,
      NULL,
      NULL,
      39.294388,
      25,
      62.602385,
      30.016622,
      69,
      43,
      65.352411,
      22.553391,
      38,
      '11-23-1979',
      34.456247,
      24.053412,
      7,
      65.384951,
      60.576782,
      55.425118,
      9,
      ' 3- 1-2003',
      5,
      24.814306,
      ' 5-16-1982',
      11,
      14.258010,
      15.846631,
      NULL,
      23,
      7.801166,
      1.028978,
      14.172014,
      1,
      NULL,
      0.442597,
      3,
      12,
      3.529133,
      0.825950,
      1,
      1,
      1.655167,
      '10- 2-1980',
      0.707323,
      2.202634,
      4.895830,
      ' 7-26-1979',
      136,
      NULL,
      ' 7- 0-1993',
      NULL,
      0,
      '10-23-2002',
      24.977487,
      ' 1-29-1997',
      15,
      ' 3-12-1998',
      NULL,
      21.320737,
      ' 7- 4-1979',
      NULL,
      58.723816,
      ' 6-17-1987',
      8.178612,
      23.638317,
      ' 4- 5-2003',
      NULL,
      NULL,
      ' 7-21-1983',
      0,
      3,
      NULL,
      '10- 7-1989',
      3,
      13.252232,
      20.945153,
      ' 3- 8-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


