set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9125458';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3424',
      '22111331',
      '04244231',
      NULL,
      '02433033',
      '33112023',
      '23230044',
      '21114342',
      '11220004',
      '21322124',
      '12342141',
      '41303140',
      '02311212',
      '01143232',
      NULL,
      '40322230',
      NULL,
      '20222243',
      '32022023',
      '24402410',
      '21112404',
      '24223344',
      '21211213',
      NULL,
      '44122343',
      '34312443',
      '00132000',
      NULL,
      '02421043',
      '21243221',
      '30121232',
      '24243003',
      NULL,
      '33331400',
      '31344110',
      '24034321',
      '23134212',
      '41422341',
      '03412330',
      '32211344',
      '02012244',
      '02433402',
      '30314201',
      '13223010',
      '32134302',
      '144',
      '10',
      NULL,
      NULL,
      '3413300',
      1,
      0.841914,
      3,
      NULL,
      '110131',
      3,
      ' 4- 4-1982',
      ' 3- 8-1989',
      105.025064,
      NULL,
      14,
      12.792971,
      29.922180,
      19.308795,
      60.933859,
      10,
      NULL,
      19.324020,
      31,
      0,
      6.733754,
      7.916278,
      1.744371,
      17,
      NULL,
      6.626301,
      10.878528,
      NULL,
      46,
      11.042447,
      NULL,
      10.562519,
      NULL,
      66.655801,
      46.746368,
      40.312254,
      1,
      NULL,
      161.920645,
      NULL,
      24,
      51,
      7.872308,
      20.440078,
      53,
      192,
      '10-16-1979',
      1.930205,
      0,
      2,
      2.623468,
      0.800070,
      1.527868,
      0.372699,
      4.185929,
      0,
      1.936099,
      1,
      1.929053,
      0.988027,
      NULL,
      0,
      0.377491,
      1.393453,
      1,
      0.053946,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-10-2003',
      NULL,
      5.204716,
      4.653805,
      9,
      5,
      NULL,
      ' 5- 1-1981',
      NULL,
      NULL,
      203,
      0,
      NULL,
      82,
      0.837463,
      1,
      114.447243,
      1,
      0.618635,
      NULL,
      NULL,
      68.177062,
      60,
      NULL,
      1,
      61,
      6,
      84,
      87,
      NULL,
      NULL,
      NULL,
      77.999317,
      ' 8- 6-1978',
      NULL,
      24,
      NULL,
      78,
      101,
      NULL,
      5.212975,
      ' 7-24-1985',
      16,
      14,
      '11-27-1996',
      1.577362,
      2,
      3,
      0.484241,
      13.806908,
      NULL,
      NULL,
      24,
      1,
      111.018521,
      3.464272,
      0,
      NULL,
      19.373187,
      1.754910,
      0,
      0.724259,
      0.610511,
      ' 4-19-1975',
      11.036208,
      NULL,
      3,
      ' 7-28-1977',
      47,
      7,
      ' 1-13-1981',
      4.879382,
      4,
      ' 1-15-1996',
      28,
      '10-15-1976',
      14,
      ' 6-12-1979',
      7.015052,
      NULL,
      ' 8-26-2000',
      NULL,
      55.672267,
      ' 2-16-1977',
      2,
      4,
      ' 2-22-1981',
      2.368610,
      0,
      ' 6-17-1975',
      2,
      NULL,
      23,
      ' 0-24-1974',
      NULL,
      38.894346,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.535860);
commit;
end;
/


