set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9314608';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '1',
      '2',
      '2',
      '0',
      NULL,
      '2',
      NULL,
      '2',
      '4',
      '3',
      '4',
      '2',
      '3',
      '1',
      '1',
      NULL,
      '2',
      '2',
      '1',
      '4',
      '1',
      '0',
      '',
      NULL,
      '',
      '3',
      '3',
      NULL,
      '4',
      NULL,
      '',
      '',
      '1',
      '2',
      NULL,
      '3',
      NULL,
      '0',
      '4',
      '3',
      '3',
      '1',
      '1',
      NULL,
      NULL,
      25,
      NULL,
      '4413222',
      NULL,
      NULL,
      NULL,
      NULL,
      '302012',
      1,
      ' 2-15-1976',
      ' 3- 7-1997',
      29.602503,
      NULL,
      26.887604,
      NULL,
      21,
      9,
      91.156824,
      7.727707,
      NULL,
      NULL,
      28,
      2,
      10.772648,
      0.924993,
      7.219493,
      4.307859,
      1.318703,
      0,
      NULL,
      NULL,
      6,
      16.116990,
      NULL,
      2.199052,
      1,
      NULL,
      68,
      70,
      73.868979,
      105,
      41,
      ' 2-27-1988',
      21,
      21,
      2.840067,
      10.645519,
      65,
      31,
      ' 8-10-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      33,
      15,
      4,
      7.746464,
      5,
      ' 4-13-1995',
      1,
      3.772091,
      177.893518,
      1,
      1.429303,
      NULL,
      2,
      3,
      81,
      NULL,
      NULL,
      NULL,
      '10-13-1990',
      89,
      53.363401,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      83.149875,
      18,
      5,
      95.753550,
      71,
      NULL,
      17,
      NULL,
      15.660241,
      20,
      44,
      73,
      8,
      ' 7-28-2003',
      13,
      16,
      ' 6- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      18.219097,
      7,
      1,
      NULL,
      0,
      NULL,
      1.906798,
      0,
      NULL,
      NULL,
      1.414628,
      2.586595,
      0,
      1,
      ' 4-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      150,
      4,
      '10- 1-1977',
      NULL,
      NULL,
      NULL,
      40,
      ' 5- 0-2003',
      NULL,
      ' 3- 0-1985',
      5,
      14,
      ' 3-20-1997',
      95.748675,
      93,
      ' 3- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      48.535528,
      25,
      38,
      '11- 3-2001',
      1,
      21,
      ' 7-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


