set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '3',
      NULL,
      '3',
      '0',
      '0',
      '4',
      '2',
      '1',
      '2',
      '0',
      '1',
      '3',
      NULL,
      '3',
      '2',
      '2',
      '4',
      '4',
      '3',
      '0',
      NULL,
      '3',
      '',
      '3',
      '',
      '1',
      '4',
      '0',
      '4',
      '4',
      NULL,
      '',
      '0',
      '1',
      '0',
      '3',
      '0',
      '0',
      '0',
      '3',
      '3',
      NULL,
      NULL,
      '323',
      '14',
      NULL,
      19.555402,
      '3133341',
      3.436704,
      NULL,
      0,
      NULL,
      '324331',
      3.838185,
      ' 4- 8-1987',
      '11-23-1996',
      90,
      14,
      10.457925,
      30.383419,
      45.992000,
      22.743277,
      116,
      NULL,
      28.705310,
      26.165828,
      13.141387,
      22.264092,
      33.331395,
      1,
      18,
      6.544198,
      2,
      2,
      16.292759,
      NULL,
      NULL,
      10.307143,
      137,
      6,
      1,
      NULL,
      267.551345,
      51.329405,
      87.132664,
      NULL,
      NULL,
      NULL,
      33.043371,
      38,
      35.902289,
      27.424894,
      97,
      65,
      '11-19-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.912301,
      NULL,
      NULL,
      NULL,
      NULL,
      3.739879,
      ' 8- 7-1995',
      0.816810,
      1.840694,
      NULL,
      0.467066,
      3.595204,
      27,
      NULL,
      1.812726,
      16.637190,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1993',
      5.791621,
      110.656869,
      84,
      71.924889,
      120.123537,
      112.467160,
      2,
      NULL,
      41,
      109.748808,
      106,
      7,
      '11-11-1986',
      21,
      NULL,
      9,
      NULL,
      83.927668,
      9,
      8,
      '10-18-1984',
      26.843649,
      25,
      NULL,
      19.562287,
      15,
      NULL,
      18,
      NULL,
      8.915637,
      1.892731,
      NULL,
      1,
      3.186293,
      0.343544,
      13.451145,
      NULL,
      26,
      1.451255,
      7.414072,
      0,
      2.398769,
      '11- 4-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      3.389084,
      '11- 0-1985',
      NULL,
      NULL,
      NULL,
      41.479100,
      ' 2- 6-1977',
      34.579192,
      ' 5- 1-1979',
      NULL,
      0,
      ' 3-22-1990',
      NULL,
      34,
      ' 3-18-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      61.783412,
      NULL,
      17,
      ' 6-10-1975',
      1.810010,
      60,
      ' 3- 7-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


