set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4143',
      '23202323',
      NULL,
      '11311220',
      '31101204',
      '41043440',
      '44021043',
      '01443021',
      NULL,
      '41444330',
      '11301111',
      NULL,
      NULL,
      NULL,
      '33424100',
      '01433124',
      NULL,
      '41110114',
      '42030303',
      NULL,
      '21241034',
      '11222412',
      '32100110',
      '42004242',
      '40412021',
      '23432412',
      '01014044',
      '44012344',
      '43304331',
      '13334034',
      NULL,
      '21142001',
      '24142412',
      NULL,
      '23020230',
      '01334413',
      '03321114',
      NULL,
      '00104334',
      '33321121',
      '02430221',
      '34414200',
      NULL,
      '33310034',
      '00004310',
      '343',
      NULL,
      NULL,
      NULL,
      '1300332',
      1.246050,
      NULL,
      3,
      NULL,
      '131014',
      2.375286,
      '10- 1-1977',
      NULL,
      44,
      NULL,
      NULL,
      0,
      12,
      NULL,
      NULL,
      NULL,
      36,
      28,
      43,
      27,
      19,
      10,
      11,
      18,
      15,
      5.271664,
      75,
      8,
      NULL,
      17,
      86.996127,
      14,
      1.052773,
      NULL,
      3,
      93.405501,
      191,
      242,
      255,
      ' 0-20-1991',
      30,
      45,
      13.979061,
      13.697433,
      236.271011,
      208,
      ' 0- 9-1981',
      1.278440,
      0.657729,
      4.619198,
      2,
      3,
      NULL,
      1.138296,
      0.379045,
      0,
      0.832586,
      0,
      1.373170,
      NULL,
      0.827196,
      1.216045,
      1,
      1.625172,
      1.682756,
      1.562676,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1987',
      NULL,
      9,
      6,
      0.175579,
      0,
      4,
      '11- 8-1986',
      0.967232,
      4,
      NULL,
      1,
      2,
      91,
      1.152357,
      1.032683,
      NULL,
      0,
      4.581380,
      218.601523,
      ' 0- 0-2001',
      NULL,
      39.527321,
      53,
      9,
      NULL,
      36.344842,
      27,
      91.607783,
      57,
      62.141851,
      47.115453,
      81,
      NULL,
      14.602127,
      22.119328,
      11.858172,
      23,
      88,
      NULL,
      12,
      ' 0- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612879,
      6,
      1.879692,
      NULL,
      56.878458,
      NULL,
      NULL,
      54.689552,
      1,
      '10-10-1993',
      14,
      ' 4-25-1985',
      38.375985,
      NULL,
      NULL,
      1.957717,
      ' 9-27-1993',
      NULL,
      15,
      NULL,
      4,
      18,
      NULL,
      5.322051,
      6,
      NULL,
      3,
      2,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.494284);
commit;
end;
/


