set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2211',
      '34420241',
      '24400240',
      '34130314',
      '44342123',
      '04244241',
      '20430024',
      NULL,
      '14001343',
      '23131202',
      '31413020',
      NULL,
      '20122101',
      '13210221',
      NULL,
      '30324312',
      NULL,
      '34403342',
      '44033320',
      '32320313',
      '40444430',
      NULL,
      '11301300',
      '22322304',
      '23133324',
      '33113330',
      '44222414',
      '01111411',
      '32011401',
      '03222143',
      '21224233',
      '10200120',
      NULL,
      '12412222',
      '33433032',
      '03103340',
      NULL,
      NULL,
      '23312241',
      '40220422',
      NULL,
      '41114200',
      NULL,
      '01222324',
      '13134111',
      NULL,
      '20',
      34,
      1,
      '1411214',
      NULL,
      1,
      0,
      NULL,
      '014111',
      NULL,
      '11- 1-1996',
      ' 2-16-1989',
      62.901827,
      NULL,
      27.783860,
      NULL,
      NULL,
      24,
      100.422357,
      NULL,
      6,
      22.371861,
      9.754391,
      17.475510,
      5.507444,
      21,
      8,
      3,
      10.082736,
      NULL,
      77,
      NULL,
      27,
      0.909474,
      NULL,
      28.708845,
      0,
      132.650622,
      124.979625,
      90.421354,
      79.686690,
      30,
      NULL,
      '10- 2-1982',
      8.835553,
      38.905994,
      3.119816,
      15,
      NULL,
      161.818141,
      ' 5- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.016501,
      NULL,
      NULL,
      11,
      NULL,
      3,
      NULL,
      1,
      0,
      72,
      NULL,
      0.776444,
      153,
      0,
      1.241699,
      18,
      NULL,
      NULL,
      NULL,
      ' 9-17-1974',
      NULL,
      42.176849,
      28.687226,
      29,
      71,
      2,
      56.431942,
      38,
      NULL,
      51.682564,
      11.128420,
      NULL,
      '10- 1-1996',
      NULL,
      0.758597,
      3.893554,
      6,
      NULL,
      17.871463,
      11.360403,
      ' 5-27-1983',
      37,
      20.525235,
      ' 7- 7-1995',
      10,
      12,
      24.573335,
      30,
      30,
      15.888838,
      0,
      28.431973,
      1,
      122.067781,
      1.637252,
      0.024529,
      25,
      1.294505,
      1,
      0.921092,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      276.146204,
      0.559504,
      ' 3-18-1979',
      NULL,
      NULL,
      NULL,
      20.805982,
      ' 7- 9-1986',
      4.423721,
      '11-10-1989',
      NULL,
      20,
      ' 9-27-1984',
      38,
      64.367030,
      ' 4-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '10- 3-1984',
      1.728523,
      19,
      0,
      ' 6-24-1992',
      0.814091,
      NULL,
      '10-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


